/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.table;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.schematics.client.ClientSchematicLoader;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.table.SchematicTableBlockEntity;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.foundation.utility.CreatePaths;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Util;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;

public class SchematicTableScreen
extends AbstractSimiContainerScreen<SchematicTableMenu> {
    private final Component uploading = CreateLang.translateDirect("gui.schematicTable.uploading", new Object[0]);
    private final Component finished = CreateLang.translateDirect("gui.schematicTable.finished", new Object[0]);
    private final Component refresh = CreateLang.translateDirect("gui.schematicTable.refresh", new Object[0]);
    private final Component folder = CreateLang.translateDirect("gui.schematicTable.open_folder", new Object[0]);
    private final Component noSchematics = CreateLang.translateDirect("gui.schematicTable.noSchematics", new Object[0]);
    private final Component availableSchematicsTitle = CreateLang.translateDirect("gui.schematicTable.availableSchematics", new Object[0]);
    protected AllGuiTextures background;
    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private ElementWidget renderedItem;
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public SchematicTableScreen(SchematicTableMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.background = AllGuiTextures.SCHEMATIC_TABLE;
    }

    public static SchematicTableScreen create(Minecraft mc, MenuType<SchematicTableBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        SchematicTableBlockEntity entity = (SchematicTableBlockEntity)SchematicTableScreen.getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(entity.problemPath(), com.zurrtum.create.Create.LOGGER);){
            ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)extraData.registryAccess(), (CompoundTag)extraData.readNbt());
            entity.readClient(view);
            SchematicTableScreen schematicTableScreen = (SchematicTableScreen)((Object)type.create(SchematicTableScreen::new, syncId, inventory, title, entity));
            return schematicTableScreen;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.getChildAt(mouseX, mouseY).filter(element -> element.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent();
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 8);
        super.init();
        Create.SCHEMATIC_SENDER.refresh();
        List<Component> availableSchematics = Create.SCHEMATIC_SENDER.getAvailableSchematics();
        int y = this.topPos + 2;
        this.schematicsLabel = new Label(this.leftPos + 51, y + 26, CommonComponents.EMPTY).withShadow();
        this.schematicsLabel.text = CommonComponents.EMPTY;
        if (!availableSchematics.isEmpty()) {
            this.schematicsArea = new SelectionScrollInput(this.leftPos + 45, y + 21, 139, 18).forOptions(availableSchematics).titled(this.availableSchematicsTitle.plainCopy()).writingTo(this.schematicsLabel);
            this.addRenderableWidget(this.schematicsArea);
            this.addRenderableWidget(this.schematicsLabel);
        }
        this.confirmButton = new IconButton(this.leftPos + 44, y + 56, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (((SchematicTableMenu)this.menu).canWrite() && this.schematicsArea != null) {
                ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
                this.progress = 0.0f;
                this.chasingProgress = 0.0f;
                this.lastChasingProgress = 0.0f;
                List<Component> availableSchematics1 = schematicSender.getAvailableSchematics();
                Component schematic = availableSchematics1.get(this.schematicsArea.getState());
                schematicSender.startNewUpload(this.minecraft, schematic.getString());
            }
        });
        this.folderButton = new IconButton(this.leftPos + 20, y + 21, AllIcons.I_OPEN_FOLDER);
        this.folderButton.withCallback(() -> Util.getPlatform().openFile(CreatePaths.SCHEMATICS_DIR.toFile()));
        this.folderButton.setToolTip(this.folder);
        this.refreshButton = new IconButton(this.leftPos + 206, y + 21, AllIcons.I_REFRESH);
        this.refreshButton.withCallback(() -> {
            ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
            schematicSender.refresh();
            List<Component> availableSchematics1 = schematicSender.getAvailableSchematics();
            this.removeWidget(this.schematicsArea);
            if (!availableSchematics1.isEmpty()) {
                this.schematicsArea = new SelectionScrollInput(this.leftPos + 45, this.topPos + 21, 139, 18).forOptions(availableSchematics1).titled(this.availableSchematicsTitle.plainCopy()).writingTo(this.schematicsLabel);
                this.schematicsArea.onChanged();
                this.addRenderableWidget(this.schematicsArea);
            } else {
                this.schematicsArea = null;
                this.schematicsLabel.text = CommonComponents.EMPTY;
            }
        });
        this.refreshButton.setToolTip(this.refresh);
        this.addRenderableWidget(this.confirmButton);
        this.addRenderableWidget(this.folderButton);
        this.addRenderableWidget(this.refreshButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + this.background.getWidth(), y + this.background.getHeight() - 40, 48, 48), (Object)new Rect2i(this.refreshButton.getX(), this.refreshButton.getY(), this.refreshButton.getWidth(), this.refreshButton.getHeight()));
        this.renderedItem = new ElementWidget(this.leftPos + this.background.getWidth(), this.topPos + this.background.getHeight() - 40).showingElement(GuiGameElement.of(AllItems.SCHEMATIC_TABLE.getDefaultInstance()).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.leftPos, this.topPos);
        Component titleText = ((SchematicTableBlockEntity)((SchematicTableMenu)this.menu).contentHolder).isUploading ? this.uploading : (((SchematicTableMenu)this.menu).getSlot(1).hasItem() ? this.finished : this.title);
        graphics.drawString(this.font, titleText, this.leftPos + (this.background.getWidth() - 8 - this.font.width((FormattedText)titleText)) / 2, this.topPos + 4, -11513776, false);
        if (this.schematicsArea == null) {
            graphics.drawString(this.font, this.noSchematics, this.leftPos + 54, this.topPos + 28, -2894893, true);
        }
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getWidth() * Mth.lerp((float)partialTicks, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getHeight();
        graphics.blit(RenderPipelines.GUI_TEXTURED, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.location, this.leftPos + 70, this.topPos + 59, (float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartX(), (float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartY(), width, height, 256, 256);
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        boolean finished = ((SchematicTableMenu)this.menu).getSlot(1).hasItem();
        if (((SchematicTableBlockEntity)((SchematicTableMenu)this.menu).contentHolder).isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((SchematicTableBlockEntity)((SchematicTableMenu)this.menu).contentHolder).uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.active = false;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(-3351041);
                String uploadingSchematic = ((SchematicTableBlockEntity)((SchematicTableMenu)this.menu).contentHolder).uploadingSchematic;
                this.schematicsLabel.text = uploadingSchematic == null ? null : Component.literal((String)uploadingSchematic);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.visible = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.active = true;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(-1);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.writingTo(this.schematicsLabel);
                this.schematicsArea.visible = true;
            }
        }
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

