/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.bogey;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BogeyBlockEntityRenderer<T extends AbstractBogeyBlockEntity>
implements BlockEntityRenderer<T, BogeyBlockEntityRenderState> {
    public BogeyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public BogeyBlockEntityRenderState createRenderState() {
        return new BogeyBlockEntityRenderState();
    }

    public void extractRenderState(T be, BogeyBlockEntityRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.blockState = be.getBlockState();
        Block block = state.blockState.getBlock();
        if (!(block instanceof AbstractBogeyBlock)) {
            return;
        }
        AbstractBogeyBlock bogey = (AbstractBogeyBlock)block;
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        Level world = be.getLevel();
        int n = state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        if (state.blockState.getValue(AbstractBogeyBlock.AXIS) == Direction.Axis.X) {
            state.yRot = 1.5707964f;
        }
        state.bogeyData = ((AbstractBogeyBlockEntity)((Object)be)).getBogeyData();
        if (state.bogeyData == null) {
            state.bogeyData = new CompoundTag();
        }
        state.data = AllBogeyStyleRenders.getRenderData(((AbstractBogeyBlockEntity)((Object)be)).getStyle(), bogey.getSize(), tickProgress, state.lightCoords, ((AbstractBogeyBlockEntity)((Object)be)).getVirtualAngle(tickProgress), ((AbstractBogeyBlockEntity)((Object)be)).getBogeyData(), false);
    }

    public void submit(BogeyBlockEntityRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.data == null) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        if (state.yRot != 0.0f) {
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.yRot));
        }
        state.data.render(matrices, queue);
        matrices.popPose();
    }

    public static class BogeyBlockEntityRenderState
    extends BlockEntityRenderState {
        public float yRot;
        public CompoundTag bogeyData;
        public BogeyRenderState data;
    }

    public static interface BogeyRenderState {
        public void render(PoseStack var1, SubmitNodeCollector var2);
    }
}

