/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.observer;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.observer.TrackObserverBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrackObserverVisual
extends AbstractBlockEntityVisual<TrackObserverBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance overlay;
    private BlockPos oldTargetPos;

    public TrackObserverVisual(VisualizationContext ctx, TrackObserverBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.overlay = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.TRACK_OBSERVER_OVERLAY)).createInstance();
        this.setupVisual();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        this.setupVisual();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.overlay);
    }

    @Override
    protected void _delete() {
        this.overlay.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept(this.overlay);
    }

    private void setupVisual() {
        TrackTargetingBehaviour<TrackObserver> target = ((TrackObserverBlockEntity)this.blockEntity).edgePoint;
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = ((TrackObserverBlockEntity)this.blockEntity).getLevel();
        BlockState trackState = level.getBlockState(targetPosition);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            this.overlay.setZeroTransform().setChanged();
            return;
        }
        ITrackBlock trackBlock = (ITrackBlock)block;
        if (!targetPosition.equals((Object)this.oldTargetPos)) {
            this.oldTargetPos = targetPosition;
            this.overlay.setIdentityTransform().translate((Vec3i)targetPosition.subtract(this.renderOrigin()));
            TrackBlockRenderer renderer = AllTrackRenders.get(trackBlock);
            if (renderer != null) {
                TrackTargetingBehaviour.RenderedTrackOverlayType type = TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER;
                renderer.prepareTrackOverlay(this.overlay, (BlockGetter)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
            }
            this.overlay.setChanged();
        }
    }
}

