/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.schedule;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.AllScheduleRenders;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.trains.schedule.DestinationSuggestions;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.ModularGuiLine;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.GlobalRailwayManager;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.ScheduleEntry;
import com.zurrtum.create.content.trains.schedule.ScheduleMenu;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ScheduleEditPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class ScheduleScreen
extends AbstractSimiContainerScreen<ScheduleMenu> {
    private static final int CARD_HEADER = 22;
    private static final int CARD_WIDTH = 195;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private List<LerpedFloat> horizontalScrolls = new ArrayList<LerpedFloat>();
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private ElementWidget renderedItem;
    private Schedule schedule;
    private IconButton confirmButton;
    private IconButton cyclicButton;
    private Indicator cyclicIndicator;
    private IconButton resetProgress;
    private IconButton skipProgress;
    private ScheduleInstruction editingDestination;
    private ScheduleWaitCondition editingCondition;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    private IconButton editorConfirm;
    private IconButton editorDelete;
    private ModularGuiLine editorSubWidgets;
    private Consumer<Boolean> onEditorClose;
    private DestinationSuggestions destinationSuggestions;
    private Component clickToEdit = CreateLang.translateDirect("gui.schedule.lmb_edit", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
    private Component rClickToDelete = CreateLang.translateDirect("gui.schedule.rmb_remove", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public ScheduleScreen(ScheduleMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.schedule = new Schedule();
        CompoundTag tag = (CompoundTag)((ItemStack)menu.contentHolder).get(AllDataComponents.TRAIN_SCHEDULE);
        if (tag != null && !tag.isEmpty()) {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleScreen", com.zurrtum.create.Create.LOGGER);){
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)menu.player.registryAccess(), (CompoundTag)tag);
                this.schedule = Schedule.read(view);
            }
        }
        menu.slotsActive = false;
        this.editorSubWidgets = new ModularGuiLine();
    }

    public static ScheduleScreen create(Minecraft mc, MenuType<ItemStack> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (ScheduleScreen)((Object)type.create(ScheduleScreen::new, syncId, inventory, title, ScheduleScreen.getStack(extraData)));
    }

    @Override
    protected void init() {
        AllGuiTextures bg = AllGuiTextures.SCHEDULE;
        this.setWindowSize(bg.getWidth(), bg.getHeight());
        super.init();
        this.clearWidgets();
        this.confirmButton = new IconButton(this.leftPos + bg.getWidth() - 42, this.topPos + bg.getHeight() - 30, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.cyclicIndicator = new Indicator(this.leftPos + 21, this.topPos + 196, CommonComponents.EMPTY);
        this.cyclicIndicator.state = this.schedule.cyclic ? Indicator.State.ON : Indicator.State.OFF;
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(CreateLang.translateDirect("schedule.loop", new Object[0]));
        tip.add(CreateLang.translateDirect("gui.schematicannon.optionDisabled", new Object[0]).withStyle(ChatFormatting.RED));
        tip.add(CreateLang.translateDirect("schedule.loop1", new Object[0]).withStyle(ChatFormatting.GRAY));
        tip.add(CreateLang.translateDirect("schedule.loop2", new Object[0]).withStyle(ChatFormatting.GRAY));
        ArrayList<MutableComponent> tipEnabled = new ArrayList<MutableComponent>(tip);
        tipEnabled.set(1, CreateLang.translateDirect("gui.schematicannon.optionEnabled", new Object[0]).withStyle(ChatFormatting.DARK_GREEN));
        this.cyclicButton = new IconButton(this.leftPos + 21, this.topPos + 196, AllIcons.I_REFRESH);
        this.cyclicButton.withCallback(() -> {
            this.cyclicButton.green = this.schedule.cyclic = !this.schedule.cyclic;
            this.cyclicButton.getToolTip().clear();
            this.cyclicButton.getToolTip().addAll(this.schedule.cyclic ? tipEnabled : tip);
        });
        this.cyclicButton.green = this.schedule.cyclic;
        this.cyclicButton.getToolTip().clear();
        this.cyclicButton.getToolTip().addAll(this.schedule.cyclic ? tipEnabled : tip);
        this.addRenderableWidget(this.cyclicButton);
        this.resetProgress = new IconButton(this.leftPos + 45, this.topPos + 196, AllIcons.I_PRIORITY_VERY_HIGH);
        this.resetProgress.withCallback(() -> {
            this.schedule.savedProgress = 0;
            this.resetProgress.active = false;
        });
        this.resetProgress.active = this.schedule.savedProgress > 0 && !this.schedule.entries.isEmpty();
        this.resetProgress.setToolTip((Component)CreateLang.translateDirect("schedule.reset", new Object[0]));
        this.addRenderableWidget(this.resetProgress);
        this.skipProgress = new IconButton(this.leftPos + 63, this.topPos + 196, AllIcons.I_PRIORITY_LOW);
        this.skipProgress.withCallback(() -> {
            ++this.schedule.savedProgress;
            this.schedule.savedProgress %= this.schedule.entries.size();
            this.resetProgress.active = this.schedule.savedProgress > 0;
        });
        this.skipProgress.active = this.schedule.entries.size() > 1;
        this.skipProgress.setToolTip((Component)CreateLang.translateDirect("schedule.skip", new Object[0]));
        this.addRenderableWidget(this.skipProgress);
        this.stopEditing();
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + bg.getWidth(), this.topPos + bg.getHeight() - 56, 48, 48));
        this.horizontalScrolls.clear();
        for (int i = 0; i < this.schedule.entries.size(); ++i) {
            this.horizontalScrolls.add(LerpedFloat.linear().startWithValue(0.0));
        }
        this.renderedItem = new ElementWidget(this.leftPos + AllGuiTextures.SCHEDULE.getWidth(), this.topPos + AllGuiTextures.SCHEDULE.getHeight() - 56).showingElement(GuiGameElement.of((ItemStack)((ScheduleMenu)this.menu).contentHolder).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    public static <T> List<MutableComponent> getTypeOptions(List<Pair<Identifier, T>> list) {
        String langSection = list.equals(AllSchedules.INSTRUCTION_TYPES) ? "instruction." : "condition.";
        return list.stream().map(Pair::getFirst).map(rl -> rl.getNamespace() + ".schedule." + langSection + rl.getPath()).map(Component::translatable).toList();
    }

    protected <T extends ScheduleDataEntry> void startEditing(IScheduleInput<T> field, T input, Consumer<Boolean> onClose, boolean allowDeletion) {
        int i;
        this.onEditorClose = onClose;
        this.confirmButton.visible = false;
        this.cyclicButton.visible = false;
        this.cyclicIndicator.visible = false;
        this.skipProgress.visible = false;
        this.resetProgress.visible = false;
        this.scrollInput = new SelectionScrollInput(this.leftPos + 56, this.topPos + 65, 143, 16);
        this.scrollInputLabel = new Label(this.leftPos + 59, this.topPos + 69, CommonComponents.EMPTY).withShadow();
        this.editorConfirm = new IconButton(this.leftPos + 56 + 168, this.topPos + 65 + 22, AllIcons.I_CONFIRM);
        if (allowDeletion) {
            this.editorDelete = new IconButton(this.leftPos + 56 - 45, this.topPos + 65 + 22, AllIcons.I_TRASH);
        }
        ((ScheduleMenu)this.menu).slotsActive = true;
        ((ScheduleMenu)this.menu).targetSlotsActive = field.slotsTargeted();
        for (int i2 = 0; i2 < field.slotsTargeted(); ++i2) {
            ItemStack item = field.getItem(input, i2);
            ((ScheduleMenu)this.menu).ghostInventory.setItem(i2, item);
            this.minecraft.player.connection.send((Packet)new GhostItemSubmitPacket(item, i2));
        }
        if (input instanceof ScheduleInstruction) {
            ScheduleInstruction instruction = (ScheduleInstruction)input;
            int startIndex = 0;
            for (i = 0; i < AllSchedules.INSTRUCTION_TYPES.size(); ++i) {
                if (!AllSchedules.INSTRUCTION_TYPES.get(i).getFirst().equals((Object)instruction.getId())) continue;
                startIndex = i;
            }
            this.editingDestination = instruction;
            this.updateEditorSubwidgets(field, this.editingDestination);
            this.scrollInput.forOptions(ScheduleScreen.getTypeOptions(AllSchedules.INSTRUCTION_TYPES)).titled(CreateLang.translateDirect("schedule.instruction_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                Pair<Identifier, Function<Identifier, ? extends ScheduleInstruction>> pair = AllSchedules.INSTRUCTION_TYPES.get((int)index);
                ScheduleInstruction newlyCreated = pair.getSecond().apply(pair.getFirst());
                if (this.editingDestination.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingDestination = newlyCreated;
                this.updateEditorSubwidgets(AllScheduleRenders.get(newlyCreated), this.editingDestination);
            }).setState(startIndex);
        }
        if (input instanceof ScheduleWaitCondition) {
            ScheduleWaitCondition cond = (ScheduleWaitCondition)input;
            int startIndex = 0;
            for (i = 0; i < AllSchedules.CONDITION_TYPES.size(); ++i) {
                if (!AllSchedules.CONDITION_TYPES.get(i).getFirst().equals((Object)cond.getId())) continue;
                startIndex = i;
            }
            this.editingCondition = cond;
            this.updateEditorSubwidgets(field, this.editingCondition);
            this.scrollInput.forOptions(ScheduleScreen.getTypeOptions(AllSchedules.CONDITION_TYPES)).titled(CreateLang.translateDirect("schedule.condition_type", new Object[0])).writingTo(this.scrollInputLabel).calling(index -> {
                Pair<Identifier, Function<Identifier, ? extends ScheduleWaitCondition>> pair = AllSchedules.CONDITION_TYPES.get((int)index);
                ScheduleWaitCondition newlyCreated = pair.getSecond().apply(pair.getFirst());
                if (this.editingCondition.getId().equals((Object)newlyCreated.getId())) {
                    return;
                }
                this.editingCondition = newlyCreated;
                this.updateEditorSubwidgets(AllScheduleRenders.get(newlyCreated), this.editingCondition);
            }).setState(startIndex);
        }
        this.addRenderableWidget(this.scrollInput);
        this.addRenderableWidget(this.scrollInputLabel);
        this.addRenderableWidget(this.editorConfirm);
        if (allowDeletion) {
            this.addRenderableWidget(this.editorDelete);
        }
    }

    private void onDestinationEdited(String text) {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.updateCommandInfo();
        }
    }

    protected void stopEditing() {
        this.confirmButton.visible = true;
        this.cyclicButton.visible = true;
        this.cyclicIndicator.visible = true;
        this.skipProgress.visible = true;
        this.resetProgress.visible = true;
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        this.destinationSuggestions = null;
        this.removeWidget(this.scrollInput);
        this.removeWidget(this.scrollInputLabel);
        this.removeWidget(this.editorConfirm);
        this.removeWidget(this.editorDelete);
        ScheduleDataEntry input = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        IScheduleInput<ScheduleInstruction> editing = AllScheduleRenders.get(input);
        for (int i = 0; i < editing.slotsTargeted(); ++i) {
            editing.setItem((ScheduleInstruction)input, i, ((ScheduleMenu)this.menu).ghostInventory.getItem(i));
            this.minecraft.player.connection.send((Packet)new GhostItemSubmitPacket(ItemStack.EMPTY, i));
        }
        this.editorSubWidgets.saveValues(input.getData());
        this.editorSubWidgets.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        this.editingCondition = null;
        this.editingDestination = null;
        this.editorConfirm = null;
        this.editorDelete = null;
        ((ScheduleMenu)this.menu).slotsActive = false;
        this.renderedItem.getRenderElement().clear();
        this.init();
    }

    protected <T extends ScheduleDataEntry> void updateEditorSubwidgets(IScheduleInput<T> field, T input) {
        this.destinationSuggestions = null;
        ((ScheduleMenu)this.menu).targetSlotsActive = field.slotsTargeted();
        this.editorSubWidgets.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.editorSubWidgets.clear();
        field.initConfigurationWidgets(input, new ModularGuiLineBuilder(this.font, this.editorSubWidgets, this.leftPos + 77, this.topPos + 92).speechBubble());
        this.editorSubWidgets.loadValues(input.getData(), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), x$0 -> {
            GuiEventListener cfr_ignored_0 = (GuiEventListener)this.addRenderableOnly((Renderable)x$0);
        });
        if (!(input instanceof DestinationInstruction)) {
            return;
        }
        DestinationInstruction destinationInstruction = (DestinationInstruction)input;
        this.editorSubWidgets.forEach(e -> {
            if (!(e instanceof EditBox)) {
                return;
            }
            EditBox destinationBox = (EditBox)e;
            this.destinationSuggestions = new DestinationSuggestions(this.minecraft, (Screen)this, destinationBox, this.font, this.getViableStations(destinationInstruction), false, this.topPos + 33);
            this.destinationSuggestions.setAllowSuggestions(true);
            this.destinationSuggestions.updateCommandInfo();
            destinationBox.setResponder(this::onDestinationEdited);
        });
    }

    private List<IntAttached<String>> getViableStations(DestinationInstruction field) {
        GlobalRailwayManager railwayManager = Create.RAILWAYS;
        HashSet<TrackGraph> viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        for (ScheduleEntry entry : this.schedule.entries) {
            String filter;
            DestinationInstruction destination;
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (!(scheduleInstruction instanceof DestinationInstruction) || (destination = (DestinationInstruction)scheduleInstruction) == field || (filter = destination.getFilterForRegex()).isBlank()) continue;
            Iterator iterator = viableGraphs.iterator();
            block1: while (iterator.hasNext()) {
                TrackGraph trackGraph = (TrackGraph)iterator.next();
                for (GlobalStation station2 : trackGraph.getPoints(EdgePointType.STATION)) {
                    if (!station2.name.matches(filter)) continue;
                    continue block1;
                }
                iterator.remove();
            }
        }
        if (viableGraphs.isEmpty()) {
            viableGraphs = new HashSet<TrackGraph>(railwayManager.trackNetworks.values());
        }
        Vec3 position = this.minecraft.player.position();
        HashSet visited = new HashSet();
        return viableGraphs.stream().flatMap(g -> g.getPoints(EdgePointType.STATION).stream()).filter(station -> station.blockEntityPos != null).filter(station -> visited.add(station.name)).map(station -> IntAttached.with((int)Vec3.atBottomCenterOf((Vec3i)station.blockEntityPos).distanceTo(position), station.name)).toList();
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.scroll.tickChaser();
        for (LerpedFloat lerpedFloat : this.horizontalScrolls) {
            lerpedFloat.tickChaser();
        }
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.tick();
        }
        this.schedule.savedProgress = this.schedule.entries.isEmpty() ? 0 : Mth.clamp((int)this.schedule.savedProgress, (int)0, (int)(this.schedule.entries.size() - 1));
        this.resetProgress.active = this.schedule.savedProgress > 0;
        this.skipProgress.active = this.schedule.entries.size() > 1;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false);
        if (((ScheduleMenu)this.menu).slotsActive) {
            super.render(graphics, mouseX, mouseY, partialTicks);
        } else {
            for (Renderable widget : this.renderables) {
                widget.render(graphics, mouseX, mouseY, partialTicks);
            }
            this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSchedule(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.pose();
        UIRenderHelper.drawStretched(graphics, this.leftPos + 33, this.topPos + 16, 3, 173, AllGuiTextures.SCHEDULE_STRIP_DARK);
        int yOffset = 25;
        List<ScheduleEntry> entries = this.schedule.entries;
        float scrollOffset = -this.scroll.getValue(partialTicks);
        graphics.enableScissor(this.leftPos, this.topPos + 16, this.leftPos + 236, this.topPos + 189);
        for (int i = 0; i <= entries.size(); ++i) {
            if (this.schedule.savedProgress == i && !this.schedule.entries.isEmpty()) {
                matrixStack.pushMatrix();
                float expectedY = scrollOffset + (float)this.topPos + (float)yOffset + 4.0f;
                float actualY = Mth.clamp((float)expectedY, (float)(this.topPos + 18), (float)(this.topPos + 170));
                matrixStack.translate(0.0f, actualY);
                (expectedY == actualY ? AllGuiTextures.SCHEDULE_POINTER : AllGuiTextures.SCHEDULE_POINTER_OFFSCREEN).render(graphics, this.leftPos, 0);
                matrixStack.popMatrix();
            }
            matrixStack.pushMatrix();
            matrixStack.translate(0.0f, scrollOffset);
            if (i == 0 || entries.size() == 0) {
                UIRenderHelper.drawStretched(graphics, this.leftPos + 33, this.topPos + 16, 3, 10, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
            }
            if (i == entries.size()) {
                if (i > 0) {
                    yOffset += 9;
                }
                AllGuiTextures.SCHEDULE_STRIP_END.render(graphics, this.leftPos + 29, this.topPos + yOffset);
                AllGuiTextures.SCHEDULE_CARD_NEW.render(graphics, this.leftPos + 43, this.topPos + yOffset);
                matrixStack.popMatrix();
                break;
            }
            ScheduleEntry scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = this.renderScheduleEntry(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            if (i + 1 < entries.size()) {
                AllGuiTextures.SCHEDULE_STRIP_DOTTED.render(graphics, this.leftPos + 29, this.topPos + yOffset - 3);
                yOffset += 10;
            }
            matrixStack.popMatrix();
            if (!scheduleEntry.instruction.supportsConditions()) continue;
            float y1 = (float)(cardY + 24) + scrollOffset;
            float h = cardHeight - 26;
            float y2 = y1 + h;
            if (y2 > 189.0f) {
                h -= y2 - 189.0f;
            }
            if (y1 < 16.0f) {
                float correction = 16.0f - y1;
                y1 += correction;
                h -= correction;
            }
            if (h <= 0.0f) continue;
            graphics.enableScissor(this.leftPos + 43, 0, this.leftPos + 204, 400);
            matrixStack.pushMatrix();
            matrixStack.translate(0.0f, scrollOffset);
            this.renderScheduleConditions(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks, cardHeight, i);
            matrixStack.popMatrix();
            graphics.disableScissor();
            if (!this.isConditionAreaScrollable(scheduleEntry)) continue;
            matrixStack.pushMatrix();
            matrixStack.translate(0.0f, scrollOffset);
            int center = (cardHeight - 8 + 22) / 2;
            float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
            if (!Mth.equal((float)chaseTarget, (float)0.0f)) {
                AllGuiTextures.SCHEDULE_SCROLL_LEFT.render(graphics, this.leftPos + 40, this.topPos + cardY + center);
            }
            if (!Mth.equal((float)chaseTarget, (float)(scheduleEntry.conditions.size() - 1))) {
                AllGuiTextures.SCHEDULE_SCROLL_RIGHT.render(graphics, this.leftPos + 203, this.topPos + cardY + center);
            }
            matrixStack.popMatrix();
        }
        graphics.disableScissor();
        graphics.fillGradient(this.leftPos + 16, this.topPos + 16, this.leftPos + 16 + 220, this.topPos + 16 + 10, 0x77000000, 0);
        graphics.fillGradient(this.leftPos + 16, this.topPos + 179, this.leftPos + 16 + 220, this.topPos + 179 + 10, 0, 0x77000000);
    }

    public int renderScheduleEntry(GuiGraphics graphics, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int zLevel = 100;
        AllGuiTextures light = AllGuiTextures.SCHEDULE_CARD_LIGHT;
        AllGuiTextures medium = AllGuiTextures.SCHEDULE_CARD_MEDIUM;
        AllGuiTextures dark = AllGuiTextures.SCHEDULE_CARD_DARK;
        int cardWidth = 195;
        int cardHeader = 22;
        int maxRows = 0;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            maxRows = Math.max(maxRows, list.size());
        }
        ScheduleInstruction instruction = entry.instruction;
        boolean supportsConditions = instruction.supportsConditions();
        int cardHeight = cardHeader + (supportsConditions ? 24 + maxRows * 18 : 4);
        Matrix3x2fStack matrixStack = graphics.pose();
        matrixStack.pushMatrix();
        matrixStack.translate((float)(this.leftPos + 25), (float)(this.topPos + yOffset));
        UIRenderHelper.drawStretched(graphics, 0, 1, cardWidth, cardHeight - 2, light);
        UIRenderHelper.drawStretched(graphics, 1, 0, cardWidth - 2, cardHeight, light);
        UIRenderHelper.drawStretched(graphics, 1, 1, cardWidth - 2, cardHeight - 2, dark);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeight - 4, medium);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeader, supportsConditions ? light : medium);
        AllGuiTextures.SCHEDULE_CARD_REMOVE.render(graphics, cardWidth - 14, 2);
        AllGuiTextures.SCHEDULE_CARD_DUPLICATE.render(graphics, cardWidth - 14, cardHeight - 14);
        int i = this.schedule.entries.indexOf(entry);
        if (i > 0) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_UP.render(graphics, cardWidth, cardHeader - 14);
        }
        if (i < this.schedule.entries.size() - 1) {
            AllGuiTextures.SCHEDULE_CARD_MOVE_DOWN.render(graphics, cardWidth, cardHeader);
        }
        UIRenderHelper.drawStretched(graphics, 8, 0, 3, cardHeight + 10, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
        (supportsConditions ? AllGuiTextures.SCHEDULE_STRIP_TRAVEL : AllGuiTextures.SCHEDULE_STRIP_ACTION).render(graphics, 4, 6);
        if (supportsConditions) {
            AllGuiTextures.SCHEDULE_STRIP_WAIT.render(graphics, 4, 28);
        }
        IScheduleInput<ScheduleInstruction> scheduleInput = AllScheduleRenders.get(instruction);
        Pair<ItemStack, Component> destination = scheduleInput.getSummary(instruction);
        this.renderInput(graphics, destination, 26, 5, false, 100);
        scheduleInput.renderSpecialIcon(instruction, graphics, 30, 5);
        matrixStack.popMatrix();
        return cardHeight;
    }

    public void renderScheduleConditions(GuiGraphics graphics, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks, int cardHeight, int entryIndex) {
        int cardWidth = 195;
        int cardHeader = 22;
        Matrix3x2fStack matrixStack = graphics.pose();
        matrixStack.pushMatrix();
        matrixStack.translate((float)(this.leftPos + 25), (float)(this.topPos + yOffset));
        int xOffset = 26;
        float scrollOffset = this.getConditionScroll(entry, partialTicks, entryIndex);
        matrixStack.pushMatrix();
        matrixStack.translate(-scrollOffset, 0.0f);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            for (int i = 0; i < list.size(); ++i) {
                ScheduleWaitCondition scheduleWaitCondition = list.get(i);
                IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(scheduleWaitCondition);
                Math.max(maxWidth, this.renderInput(graphics, scheduleInput.getSummary(scheduleWaitCondition), xOffset, 29 + i * 18, i != 0, maxWidth));
                scheduleInput.renderSpecialIcon(scheduleWaitCondition, graphics, xOffset + 4, 29 + i * 18);
            }
            AllGuiTextures.SCHEDULE_CONDITION_APPEND.render(graphics, xOffset + (maxWidth - 10) / 2, 29 + list.size() * 18);
            xOffset += maxWidth + 10;
        }
        AllGuiTextures.SCHEDULE_CONDITION_NEW.render(graphics, xOffset - 3, 29);
        matrixStack.popMatrix();
        if (xOffset + 16 > cardWidth - 26) {
            matrixStack.rotate(-1.5707964f);
            graphics.fillGradient(-cardHeight + 2, 18, -2 - cardHeader, 28, 0x44000000, 0);
            graphics.fillGradient(-cardHeight + 2, cardWidth - 26, -2 - cardHeader, cardWidth - 16, 0, 0x44000000);
        }
        matrixStack.popMatrix();
    }

    private boolean isConditionAreaScrollable(ScheduleEntry entry) {
        int xOffset = 26;
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            xOffset += this.getConditionColumnWidth(list) + 10;
        }
        return xOffset + 16 > 169;
    }

    private float getConditionScroll(ScheduleEntry entry, float partialTicks, int entryIndex) {
        float scrollOffset = 0.0f;
        float scrollIndex = this.horizontalScrolls.get(entryIndex).getValue(partialTicks);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = this.getConditionColumnWidth(list);
            float partialOfThisColumn = Math.min(1.0f, scrollIndex);
            scrollOffset += (float)(maxWidth + 10) * partialOfThisColumn;
            scrollIndex -= partialOfThisColumn;
        }
        return scrollOffset;
    }

    private int getConditionColumnWidth(List<ScheduleWaitCondition> list) {
        int maxWidth = 0;
        for (ScheduleWaitCondition scheduleWaitCondition : list) {
            IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(scheduleWaitCondition);
            maxWidth = Math.max(maxWidth, this.getFieldSize(32, scheduleInput.getSummary(scheduleWaitCondition)));
        }
        return maxWidth;
    }

    protected int renderInput(GuiGraphics graphics, Pair<ItemStack, Component> pair, int x, int y, boolean clean, int minSize) {
        ItemStack stack = pair.getFirst();
        Component text = pair.getSecond();
        boolean hasItem = !stack.isEmpty();
        int fieldSize = Math.min(this.getFieldSize(minSize, pair), 150);
        Matrix3x2fStack matrixStack = graphics.pose();
        matrixStack.pushMatrix();
        AllGuiTextures left = clean ? AllGuiTextures.SCHEDULE_CONDITION_LEFT_CLEAN : AllGuiTextures.SCHEDULE_CONDITION_LEFT;
        AllGuiTextures middle = AllGuiTextures.SCHEDULE_CONDITION_MIDDLE;
        AllGuiTextures item = AllGuiTextures.SCHEDULE_CONDITION_ITEM;
        AllGuiTextures right = AllGuiTextures.SCHEDULE_CONDITION_RIGHT;
        matrixStack.translate((float)x, (float)y);
        UIRenderHelper.drawStretched(graphics, 0, 0, fieldSize, 16, middle);
        left.render(graphics, clean ? 0 : -3, 0);
        right.render(graphics, fieldSize - 2, 0);
        if (hasItem) {
            item.render(graphics, 3, 0);
            if (stack.getItem() != Items.STRUCTURE_VOID) {
                graphics.renderItem(stack, 4, 0);
            }
        }
        if (text != null) {
            graphics.drawString(this.font, this.font.substrByWidth((FormattedText)text, 120).getString(), hasItem ? 28 : 8, 4, -855314, true);
        }
        matrixStack.popMatrix();
        return fieldSize;
    }

    public boolean action(@Nullable GuiGraphics graphics, double mouseX, double mouseY, int click) {
        if (this.editingCondition != null || this.editingDestination != null) {
            return false;
        }
        Component empty = CommonComponents.EMPTY;
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.leftPos - 25;
        int y = my - this.topPos - 25;
        if (x < 0 || x >= 205) {
            return false;
        }
        if (y < 0 || y >= 173) {
            return false;
        }
        y = (int)((float)y + this.scroll.getValue(0.0f));
        List<ScheduleEntry> entries = this.schedule.entries;
        for (int i = 0; i < entries.size(); ++i) {
            int center;
            ScheduleEntry entry = entries.get(i);
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : entry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            ScheduleInstruction instruction = entry.instruction;
            int cardHeight = 22 + (instruction.supportsConditions() ? 24 + maxRows * 18 : 4);
            if (y >= cardHeight + 5) {
                if ((y -= cardHeight + 10) >= 0) continue;
                return false;
            }
            IScheduleInput<ScheduleInstruction> input = AllScheduleRenders.get(instruction);
            int fieldSize = this.getFieldSize(100, input.getSummary(instruction));
            if (x > 25 && x <= 25 + fieldSize && y > 4 && y <= 20) {
                ArrayList<Component> components = new ArrayList<Component>();
                components.addAll(input.getTitleAs(instruction, "instruction"));
                components.add(empty);
                components.add(this.clickToEdit);
                this.renderActionTooltip(graphics, components, mx, my);
                if (click == 0) {
                    this.startEditing(input, instruction, confirmed -> {
                        if (confirmed.booleanValue()) {
                            entry.instruction = this.editingDestination;
                        }
                    }, false);
                }
                return true;
            }
            if (x > 180 && x <= 192) {
                if (y > 0 && y <= 14) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.remove_entry", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        this.renderedItem.getRenderElement().clear();
                        this.init();
                    }
                    return true;
                }
                if (y > cardHeight - 14) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.duplicate", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.add(entries.indexOf(entry), entry.clone((HolderLookup.Provider)this.minecraft.level.registryAccess()));
                        this.renderedItem.getRenderElement().clear();
                        this.init();
                    }
                    return true;
                }
            }
            if (x > 194) {
                if (y > 7 && y <= 20 && i > 0) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.move_up", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i - 1, entry);
                        this.renderedItem.getRenderElement().clear();
                        this.init();
                    }
                    return true;
                }
                if (y > 20 && y <= 33 && i < entries.size() - 1) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.move_down", new Object[0])), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i + 1, entry);
                        this.renderedItem.getRenderElement().clear();
                        this.init();
                    }
                    return true;
                }
            }
            if (y > (center = (cardHeight - 8 + 22) / 2) - 1 && y <= center + 7 && this.isConditionAreaScrollable(entry)) {
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (x > 12 && x <= 19 && !Mth.equal((float)chaseTarget, (float)0.0f)) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
                if (x > 177 && x <= 184 && !Mth.equal((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    if (click == 0) {
                        this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    }
                    return true;
                }
            }
            if ((x -= 18) < 0 || (y -= 28) < 0 || x > 160) {
                return false;
            }
            x = (int)((float)x + (this.getConditionScroll(entry, 0.0f, i) - 8.0f));
            List<List<ScheduleWaitCondition>> columns = entry.conditions;
            for (int j = 0; j < columns.size(); ++j) {
                List<ScheduleWaitCondition> conditions = columns.get(j);
                if (x < 0) {
                    return false;
                }
                int w = this.getConditionColumnWidth(conditions);
                if (x >= w) {
                    x -= w + 10;
                    continue;
                }
                int row = y / 18;
                if (row < conditions.size() && row >= 0) {
                    boolean canRemove = conditions.size() > 1 || columns.size() > 1;
                    ArrayList<Component> components = new ArrayList<Component>();
                    components.add((Component)CreateLang.translateDirect("schedule.condition_type", new Object[0]).withStyle(ChatFormatting.GRAY));
                    ScheduleWaitCondition condition = conditions.get(row);
                    IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                    components.addAll(scheduleInput.getTitleAs(condition, "condition"));
                    components.add(empty);
                    components.add(this.clickToEdit);
                    if (canRemove) {
                        components.add(this.rClickToDelete);
                    }
                    this.renderActionTooltip(graphics, components, mx, my);
                    if (canRemove && click == 1) {
                        conditions.remove(row);
                        if (conditions.isEmpty()) {
                            columns.remove(conditions);
                        }
                    }
                    if (click == 0) {
                        this.startEditing(scheduleInput, condition, confirmed -> {
                            conditions.remove(row);
                            if (confirmed.booleanValue()) {
                                conditions.add(row, this.editingCondition);
                                return;
                            }
                            if (conditions.isEmpty()) {
                                columns.remove(conditions);
                            }
                        }, canRemove);
                    }
                    return true;
                }
                if (y > 18 * conditions.size() && y <= 18 * conditions.size() + 10 && x >= w / 2 - 5 && x < w / 2 + 5) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.add_condition", new Object[0])), mx, my);
                    if (click == 0) {
                        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                        IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                        this.startEditing(scheduleInput, condition, confirmed -> {
                            if (confirmed.booleanValue()) {
                                conditions.add(this.editingCondition);
                            }
                        }, true);
                    }
                    return true;
                }
                return false;
            }
            if (x < 0 || x > 15 || y > 20) {
                return false;
            }
            this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.alternative_condition", new Object[0])), mx, my);
            if (click == 0) {
                ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                this.startEditing(scheduleInput, condition, confirmed -> {
                    if (!confirmed.booleanValue()) {
                        return;
                    }
                    ArrayList<ScheduleWaitCondition> conditions = new ArrayList<ScheduleWaitCondition>();
                    conditions.add(this.editingCondition);
                    columns.add(conditions);
                }, true);
            }
            return true;
        }
        if (x < 18 || x > 33 || y > 14) {
            return false;
        }
        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateLang.translateDirect("gui.schedule.add_entry", new Object[0])), mx, my);
        if (click == 0) {
            ScheduleInstruction instruction = AllSchedules.createScheduleInstruction(AllSchedules.DESTINATION);
            IScheduleInput<ScheduleInstruction> scheduleInput = AllScheduleRenders.get(instruction);
            this.startEditing(scheduleInput, instruction, confirmed -> {
                if (!confirmed.booleanValue()) {
                    return;
                }
                ScheduleEntry entry = new ScheduleEntry();
                ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                ArrayList<ScheduleWaitCondition> initialConditions = new ArrayList<ScheduleWaitCondition>();
                initialConditions.add(condition);
                entry.instruction = this.editingDestination;
                entry.conditions.add(initialConditions);
                this.schedule.entries.add(entry);
            }, true);
        }
        return true;
    }

    private void renderActionTooltip(@Nullable GuiGraphics graphics, List<Component> tooltip, int mx, int my) {
        if (graphics != null) {
            graphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mx, my);
        }
    }

    private int getFieldSize(int minSize, Pair<ItemStack, Component> pair) {
        ItemStack stack = pair.getFirst();
        Component text = pair.getSecond();
        boolean hasItem = !stack.isEmpty();
        return Math.max((text == null ? 0 : this.font.width((FormattedText)text)) + (hasItem ? 20 : 0) + 16, minSize);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked(click)) {
            return true;
        }
        double pMouseX = click.x();
        double pMouseY = click.y();
        if (this.editorConfirm != null && this.editorConfirm.isMouseOver(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        if (this.editorDelete != null && this.editorDelete.isMouseOver(pMouseX, pMouseY) && this.onEditorClose != null) {
            this.onEditorClose.accept(false);
            this.stopEditing();
            return true;
        }
        if (this.action(null, pMouseX, pMouseY, click.button())) {
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        boolean hitE;
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(input)) {
            return true;
        }
        if (this.editingCondition == null && this.editingDestination == null) {
            return super.keyPressed(input);
        }
        int pKeyCode = input.key();
        boolean hitEnter = this.getFocused() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        boolean bl = hitE = this.getFocused() == null && this.minecraft.options.keyInventory.matches(input);
        if (hitE || hitEnter) {
            this.onEditorClose.accept(true);
            this.stopEditing();
            return true;
        }
        return super.keyPressed(input);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int maxRows;
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(Mth.clamp((double)pScrollY, (double)-1.0, (double)1.0))) {
            return true;
        }
        if (this.editingCondition != null || this.editingDestination != null) {
            return this.getChildAt(pMouseX, pMouseY).filter(element -> element.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY)).isPresent();
        }
        if (AllKeys.hasShiftDown()) {
            List<ScheduleEntry> entries = this.schedule.entries;
            int y = (int)(pMouseY - (double)this.topPos - 25.0 + (double)this.scroll.getValue());
            for (int i = 0; i < entries.size(); ++i) {
                ScheduleEntry entry = entries.get(i);
                maxRows = 0;
                for (List<ScheduleWaitCondition> list : entry.conditions) {
                    maxRows = Math.max(maxRows, list.size());
                }
                int cardHeight = 46 + maxRows * 18;
                if (y >= cardHeight) {
                    if ((y -= cardHeight + 9) >= 0) continue;
                    break;
                }
                if (!this.isConditionAreaScrollable(entry) || y < 24 || pMouseX < (double)(this.leftPos + 25) || pMouseX > (double)(this.leftPos + 205)) break;
                float chaseTarget = this.horizontalScrolls.get(i).getChaseTarget();
                if (pScrollY > 0.0 && !Mth.equal((float)chaseTarget, (float)0.0f)) {
                    this.horizontalScrolls.get(i).chase(chaseTarget - 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                if (pScrollY < 0.0 && !Mth.equal((float)chaseTarget, (float)(entry.conditions.size() - 1))) {
                    this.horizontalScrolls.get(i).chase(chaseTarget + 1.0f, 0.5, LerpedFloat.Chaser.EXP);
                    return true;
                }
                return false;
            }
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -133.0f;
        for (ScheduleEntry scheduleEntry : this.schedule.entries) {
            maxRows = 0;
            for (List<ScheduleWaitCondition> list : scheduleEntry.conditions) {
                maxRows = Math.max(maxRows, list.size());
            }
            max += (float)(46 + maxRows * 18 + 10);
        }
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pScrollY * 12.0);
            chaseTarget = Mth.clamp((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((int)chaseTarget, 0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, 0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.pose();
        if (this.destinationSuggestions != null) {
            matrixStack.pushMatrix();
            this.destinationSuggestions.render(graphics, mouseX, mouseY);
            matrixStack.popMatrix();
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        this.action(graphics, mouseX, mouseY, -1);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        int x = this.leftPos + 53;
        int y = this.topPos + 87;
        if (mouseX < x || mouseY < y || mouseX >= x + 120 || mouseY >= y + 18) {
            return;
        }
        ScheduleDataEntry entry = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        IScheduleInput<ScheduleInstruction> rendered = AllScheduleRenders.get(entry);
        for (int i = 0; i < Math.max(1, rendered.slotsTargeted()); ++i) {
            Slot slot;
            List<Component> secondLineTooltip = rendered.getSecondLineTooltip(i);
            if (secondLineTooltip == null || (slot = ((ScheduleMenu)this.menu).getSlot(36 + i)) == null || !slot.getItem().isEmpty() || mouseX < this.leftPos + slot.x || mouseX > this.leftPos + slot.x + 18 || mouseY < this.topPos + slot.y || mouseY > this.topPos + slot.y + 18) continue;
            this.renderActionTooltip(graphics, secondLineTooltip, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        pPartialTick = AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker());
        AllGuiTextures.SCHEDULE.render(graphics, this.leftPos, this.topPos);
        FormattedCharSequence formattedcharsequence = this.title.getVisualOrderText();
        int center = this.leftPos + (AllGuiTextures.SCHEDULE.getWidth() - 8) / 2;
        graphics.drawString(this.font, formattedcharsequence, center - this.font.width(formattedcharsequence) / 2, this.topPos + 4, -11513776, false);
        this.renderSchedule(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.editingCondition == null && this.editingDestination == null) {
            return;
        }
        graphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        AllGuiTextures.SCHEDULE_EDITOR.render(graphics, this.leftPos - 2, this.topPos + 40);
        AllGuiTextures.PLAYER_INVENTORY.render(graphics, this.leftPos + 38, this.topPos + 122);
        graphics.drawString(this.font, this.playerInventoryTitle, this.leftPos + 46, this.topPos + 128, -11513776, false);
        formattedcharsequence = this.editingCondition == null ? CreateLang.translateDirect("schedule.instruction.editor", new Object[0]).getVisualOrderText() : CreateLang.translateDirect("schedule.condition.editor", new Object[0]).getVisualOrderText();
        graphics.drawString(this.font, formattedcharsequence, center - this.font.width(formattedcharsequence) / 2, this.topPos + 44, -11513776, false);
        ScheduleDataEntry entry = this.editingCondition == null ? this.editingDestination : this.editingCondition;
        IScheduleInput<ScheduleInstruction> rendered = AllScheduleRenders.get(entry);
        for (int i = 0; i < rendered.slotsTargeted(); ++i) {
            AllGuiTextures.SCHEDULE_EDITOR_ADDITIONAL_SLOT.render(graphics, this.leftPos + 53 + 20 * i, this.topPos + 87);
        }
        if (rendered.slotsTargeted() == 0 && !rendered.renderSpecialIcon((ScheduleInstruction)entry, graphics, this.leftPos + 54, this.topPos + 88)) {
            Pair<ItemStack, Component> summary = rendered.getSummary((ScheduleInstruction)entry);
            ItemStack icon = summary.getFirst();
            if (icon.isEmpty()) {
                icon = rendered.getSecondLineIcon();
            }
            if (icon.isEmpty()) {
                AllGuiTextures.SCHEDULE_EDITOR_INACTIVE_SLOT.render(graphics, this.leftPos + 53, this.topPos + 87);
            } else {
                graphics.renderItem(icon, this.leftPos + 54, this.topPos + 88);
            }
        }
        Matrix3x2fStack pPoseStack = graphics.pose();
        pPoseStack.pushMatrix();
        pPoseStack.translate(0.0f, (float)(this.topPos + 87));
        this.editorSubWidgets.renderWidgetBG(this.leftPos + 77, graphics);
        pPoseStack.popMatrix();
    }

    public void removed() {
        super.removed();
        this.minecraft.player.connection.send((Packet)new ScheduleEditPacket(this.schedule));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

