/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.condition.TimedWaitCondition;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class TimedWaitConditionRender<T extends TimedWaitCondition>
implements IScheduleInput<T> {
    protected Component formatTime(T input, boolean compact) {
        int value = ((TimedWaitCondition)input).getValue();
        TimedWaitCondition.TimeUnit unit = ((TimedWaitCondition)input).getUnit();
        if (compact) {
            return Component.literal((String)(value + unit.suffix));
        }
        return Component.literal((String)(value + " ")).append((Component)CreateLang.translateDirect(this.getUnitKey(unit), new Object[0]));
    }

    @Override
    public List<Component> getTitleAs(T input, String type) {
        Identifier id = ((ScheduleDataEntry)input).getId();
        return ImmutableList.of((Object)Component.translatable((String)(id.getNamespace() + ".schedule." + type + "." + id.getPath())), (Object)CreateLang.translateDirect("schedule.condition.for_x_time", this.formatTime(input, false)).withStyle(ChatFormatting.DARK_AQUA));
    }

    @Override
    public ItemStack getSecondLineIcon() {
        return new ItemStack((ItemLike)Items.REPEATER);
    }

    @Override
    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect("generic.duration", new Object[0]));
    }

    public String getUnitKey(TimedWaitCondition.TimeUnit unit) {
        return "generic.unit." + unit.name().toLowerCase(Locale.ROOT);
    }

    public List<Component> getUnitOptions() {
        return CreateLang.translatedOptions(null, this.getUnitKey(TimedWaitCondition.TimeUnit.TICKS), this.getUnitKey(TimedWaitCondition.TimeUnit.SECONDS), this.getUnitKey(TimedWaitCondition.TimeUnit.MINUTES));
    }

    @Override
    public void initConfigurationWidgets(T input, ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 31, (i, l) -> {
            i.titled(CreateLang.translateDirect("generic.duration", new Object[0])).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Value");
        builder.addSelectionScrollInput(36, 85, (i, l) -> i.forOptions(this.getUnitOptions()).titled(CreateLang.translateDirect("generic.timeUnit", new Object[0])), "TimeUnit");
    }
}

