/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.signal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignalRenderer
implements BlockEntityRenderer<SignalBlockEntity, SignalRenderState> {
    public SignalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SignalRenderState createRenderState() {
        return new SignalRenderState();
    }

    public void extractRenderState(SignalBlockEntity be, SignalRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        if (VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            return;
        }
        state.blockPos = be.getBlockPos();
        state.blockState = be.getBlockState();
        state.blockEntityType = be.getType();
        state.layer = RenderTypes.solidMovingBlock();
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)world);
        if (be.getState().isRedLight(renderTime)) {
            state.model = CachedBuffers.partial(AllPartialModels.SIGNAL_ON, state.blockState);
            state.lightCoords = 240;
        } else {
            state.model = CachedBuffers.partial(AllPartialModels.SIGNAL_OFF, state.blockState);
            state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        }
        TrackTargetingBehaviour<SignalBoundary> target = be.edgePoint;
        BlockPos targetPosition = target.getGlobalPosition();
        BlockState trackState = world.getBlockState(targetPosition);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock trackBlock = (ITrackBlock)block;
        SignalBlockEntity.OverlayState overlayState = be.getOverlay();
        if (overlayState == SignalBlockEntity.OverlayState.SKIP) {
            return;
        }
        TrackBlockRenderer renderer = AllTrackRenders.get(trackBlock);
        if (renderer != null) {
            TrackTargetingBehaviour.RenderedTrackOverlayType type = overlayState == SignalBlockEntity.OverlayState.DUAL ? TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL : TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL;
            state.block = renderer.getRenderState(world, new Vec3((double)(targetPosition.getX() - state.blockPos.getX()), (double)(targetPosition.getY() - state.blockPos.getY()), (double)(targetPosition.getZ() - state.blockPos.getZ())), trackState, targetPosition, target.getTargetDirection(), target.getTargetBezier(), type, 1.0f);
        }
    }

    public void submit(SignalRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    public static class SignalRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        TrackBlockRenderState block;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

