/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrainIcons;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.zurrtum.create.client.content.trains.entity.TrainIcon;
import com.zurrtum.create.client.content.trains.station.AbstractStationScreen;
import com.zurrtum.create.client.content.trains.station.AssemblyScreen;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.content.trains.station.WideIconButton;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;

public class StationScreen
extends AbstractStationScreen {
    private EditBox nameBox;
    private EditBox trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;
    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private DoorControl doorControl;
    private ScrollInput colorTypeScroll;
    private int messedWithColors;
    private boolean switchingToAssemblyMode;

    public StationScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION;
        this.leavingAnimation = 0;
        this.trainPosition = LerpedFloat.linear().startWithValue(0.0);
        this.switchingToAssemblyMode = false;
        this.doorControl = be.doorControls.mode;
    }

    @Override
    protected void init() {
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        Consumer<String> onTextChanged = s -> this.nameBox.setX(this.nameBoxX((String)s, this.nameBox));
        this.nameBox = new EditBox((Font)new NoShadowFontWrapper(this.font), x + 23, y + 4, this.background.getWidth() - 20, 10, (Component)Component.literal((String)this.station.name));
        this.nameBox.setBordered(false);
        this.nameBox.setMaxLength(25);
        this.nameBox.setTextColor(-10935260);
        this.nameBox.setValue(this.station.name);
        this.nameBox.setFocused(false);
        this.nameBox.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        this.nameBox.setResponder(onTextChanged);
        this.nameBox.setX(this.nameBoxX(this.nameBox.getValue(), this.nameBox));
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        Runnable assemblyCallback = () -> {
            this.switchingToAssemblyMode = true;
            this.minecraft.setScreen((Screen)new AssemblyScreen(this.blockEntity, this.station));
        };
        this.newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        this.newTrainButton.withCallback(assemblyCallback);
        this.addRenderableWidget(this.newTrainButton);
        this.disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        this.disassembleTrainButton.active = false;
        this.disassembleTrainButton.visible = false;
        this.disassembleTrainButton.withCallback(assemblyCallback);
        this.addRenderableWidget(this.disassembleTrainButton);
        this.dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        this.dropScheduleButton.active = false;
        this.dropScheduleButton.visible = false;
        this.dropScheduleButton.withCallback(() -> this.minecraft.player.connection.send((Packet)StationEditPacket.dropSchedule(this.blockEntity.getBlockPos())));
        this.addRenderableWidget(this.dropScheduleButton);
        this.colorTypeScroll = new ScrollInput(x + 166, y + 17, 22, 14).titled(CreateLang.translateDirect("station.train_map_color", new Object[0]));
        this.colorTypeScroll.withRange(0, 16);
        this.colorTypeScroll.withStepFunction(ctx -> this.colorTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx));
        this.colorTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.mapColorIndex = s;
                this.messedWithColors = 10;
            }
        });
        this.colorTypeScroll.visible = false;
        this.colorTypeScroll.active = false;
        this.addRenderableWidget(this.colorTypeScroll);
        onTextChanged = s -> this.trainNameBox.setX(this.nameBoxX((String)s, this.trainNameBox));
        this.trainNameBox = new EditBox(this.font, x + 23, y + 47, this.background.getWidth() - 75, 10, CommonComponents.EMPTY);
        this.trainNameBox.setBordered(false);
        this.trainNameBox.setMaxLength(35);
        this.trainNameBox.setTextColor(-3750202);
        this.trainNameBox.setFocused(false);
        this.trainNameBox.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        this.trainNameBox.setResponder(onTextChanged);
        this.trainNameBox.active = false;
        this.tickTrainDisplay();
        Pair<ScrollInput, Label> doorControlWidgets = SlidingDoorRenderer.createWidget(this.minecraft, x + 35, y + 102, mode -> {
            this.doorControl = mode;
        }, this.doorControl);
        this.addRenderableWidget(doorControlWidgets.getFirst());
        this.addRenderableWidget(doorControlWidgets.getSecond());
    }

    @Override
    public void tick() {
        this.tickTrainDisplay();
        if (this.getFocused() != this.nameBox) {
            this.nameBox.setCursorPosition(this.nameBox.getValue().length());
            this.nameBox.setHighlightPos(this.nameBox.getCursorPosition());
        }
        if (this.getFocused() != this.trainNameBox || !this.trainNameBox.active) {
            this.trainNameBox.setCursorPosition(this.trainNameBox.getValue().length());
            this.trainNameBox.setHighlightPos(this.trainNameBox.getCursorPosition());
        }
        if (this.messedWithColors > 0) {
            --this.messedWithColors;
            if (this.messedWithColors == 0) {
                this.syncTrainNameAndColor();
            }
        }
        super.tick();
        this.updateAssemblyTooltip(this.blockEntity.edgePoint.isOnCurve() ? "no_assembly_curve" : (!this.blockEntity.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : (this.trainPresent() && !this.blockEntity.trainCanDisassemble ? "train_not_aligned" : null)));
    }

    private void tickTrainDisplay() {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            if (this.trainNameBox.active) {
                this.trainNameBox.active = false;
                this.removeWidget((GuiEventListener)this.trainNameBox);
            }
            this.leavingAnimation = 0;
            this.newTrainButton.active = this.blockEntity.edgePoint.isOrthogonal();
            this.newTrainButton.visible = true;
            this.colorTypeScroll.visible = false;
            this.colorTypeScroll.active = false;
            Train imminentTrain = this.getImminent();
            if (imminentTrain != null) {
                this.displayedTrain = new WeakReference<Train>(imminentTrain);
                this.newTrainButton.active = false;
                this.newTrainButton.visible = false;
                this.disassembleTrainButton.active = false;
                this.disassembleTrainButton.visible = true;
                this.dropScheduleButton.active = this.blockEntity.trainHasSchedule;
                this.dropScheduleButton.visible = true;
                if (this.mapModsPresent()) {
                    this.colorTypeScroll.setState(imminentTrain.mapColorIndex);
                    this.colorTypeScroll.visible = true;
                    this.colorTypeScroll.active = true;
                }
                this.trainNameBox.active = true;
                this.trainNameBox.setValue(imminentTrain.name.getString());
                this.trainNameBox.setX(this.nameBoxX(this.trainNameBox.getValue(), this.trainNameBox));
                this.addRenderableWidget((GuiEventListener)this.trainNameBox);
                int trainIconWidth = this.getTrainIconWidth(imminentTrain);
                int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130) {
                    targetPos -= trainIconWidth - 130;
                }
                float f = (float)(imminentTrain.navigation.distanceToDestination / 15.0);
                if (this.trainPresent()) {
                    f = 0.0f;
                }
                this.trainPosition.startWithValue((float)targetPos - (float)(targetPos + 5) * f);
            }
            return;
        }
        int trainIconWidth = this.getTrainIconWidth(train);
        int targetPos = this.background.getWidth() / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130) {
            targetPos -= trainIconWidth - 130;
        }
        if (this.leavingAnimation > 0) {
            this.colorTypeScroll.visible = false;
            this.colorTypeScroll.active = false;
            this.disassembleTrainButton.active = false;
            float f = 1.0f - (float)this.leavingAnimation / 80.0f;
            this.trainPosition.setValue((float)targetPos + f * f * f * (float)(this.background.getWidth() - targetPos + 5));
            --this.leavingAnimation;
            if (this.leavingAnimation > 0) {
                return;
            }
            this.displayedTrain = new WeakReference<Object>(null);
            this.disassembleTrainButton.visible = false;
            this.dropScheduleButton.active = false;
            this.dropScheduleButton.visible = false;
            return;
        }
        if (this.getImminent() != train) {
            this.leavingAnimation = 80;
            return;
        }
        boolean trainAtStation = this.trainPresent();
        this.disassembleTrainButton.active = trainAtStation && this.blockEntity.trainCanDisassemble && this.blockEntity.edgePoint.isOrthogonal();
        this.dropScheduleButton.active = this.blockEntity.trainHasSchedule;
        if (this.blockEntity.trainHasSchedule) {
            this.dropScheduleButton.setToolTip((Component)CreateLang.translateDirect(this.blockEntity.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule", new Object[0]));
        } else {
            this.dropScheduleButton.getToolTip().clear();
        }
        float f = trainAtStation ? 0.0f : (float)(train.navigation.distanceToDestination / 30.0);
        this.trainPosition.setValue((float)targetPos - (float)(targetPos + trainIconWidth) * f);
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.guiLeft + this.background.getWidth() / 2 - (Math.min(this.font.width(s), nameBox.getWidth()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            this.disassembleTrainButton.setToolTip((Component)CreateLang.translateDirect("station.disassemble_train", new Object[0]));
            this.newTrainButton.setToolTip((Component)CreateLang.translateDirect("station.create_train", new Object[0]));
            return;
        }
        for (IconButton ib : new IconButton[]{this.disassembleTrainButton, this.newTrainButton}) {
            List<Component> toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add((Component)CreateLang.translateDirect("station." + key, new Object[0]).withStyle(ChatFormatting.GRAY));
            toolTip.add((Component)CreateLang.translateDirect("station." + key + "_1", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        String text = this.nameBox.getValue();
        if (!this.nameBox.isFocused()) {
            AllGuiTextures.STATION_EDIT_NAME.render(graphics, this.nameBoxX(text, this.nameBox) + this.font.width(text) + 5, y + 1);
        }
        graphics.renderItem(AllItems.TRAIN_DOOR.getDefaultInstance(), x + 14, y + 103);
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            MutableComponent header = CreateLang.translateDirect("station.idle", new Object[0]);
            graphics.drawString(this.font, (Component)header, x + 97 - this.font.width((FormattedText)header) / 2, y + 47, -8750470, false);
            return;
        }
        float position = this.trainPosition.getValue(partialTicks);
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate(position, 0.0f);
        TrainIcon icon = AllTrainIcons.byType(train.icon);
        int offset = 0;
        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; --i) {
            Carriage carriage = carriages.get(this.blockEntity.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, graphics, x + offset, y + 20) + 1;
        }
        offset += icon.render(-1, graphics, x + offset, y + 20);
        ms.popMatrix();
        AllGuiTextures.STATION_TEXTBOX_TOP.render(graphics, x + 21, y + 42);
        UIRenderHelper.drawStretched(graphics, x + 21, y + 60, 150, 26, AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(graphics, x + 21, y + 86);
        ms.pushMatrix();
        ms.translate(Mth.clamp((float)(position + (float)offset - 13.0f), (float)25.0f, (float)159.0f), 0.0f);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(graphics, x, y + 38);
        ms.popMatrix();
        text = this.trainNameBox.getValue();
        if (!this.trainNameBox.isFocused()) {
            int buttonX = this.nameBoxX(text, this.trainNameBox) + this.font.width(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(graphics, Math.min(buttonX, this.guiLeft + 156), y + 44);
            if (this.font.width(text) > this.trainNameBox.getWidth()) {
                graphics.drawString(this.font, "...", this.guiLeft + 26, this.guiTop + 47, -5855578, true);
            }
        }
        if (!this.mapModsPresent()) {
            return;
        }
        AllGuiTextures sprite = AllGuiTextures.TRAINMAP_SPRITES;
        sprite.bind();
        int trainColorIndex = this.colorTypeScroll.getState();
        int colorRow = trainColorIndex / 4;
        int colorCol = trainColorIndex % 4;
        int rotation = AnimationTickHolder.getTicks() / 5 % 8;
        for (int slice = 0; slice < 3; ++slice) {
            int row = slice == 0 ? 1 : (slice == 2 ? 2 : 3);
            int col = rotation;
            int positionX = this.colorTypeScroll.getX() + 4;
            int positionY = this.colorTypeScroll.getY() - 1;
            int sheetX = col * 16 + colorCol * 128;
            int sheetY = row * 16 + colorRow * 64;
            graphics.blit(RenderPipelines.GUI_TEXTURED, sprite.location, positionX, positionY, (float)sheetX, (float)sheetY, 16, 16, sprite.getWidth(), sprite.getHeight());
        }
    }

    public boolean mapModsPresent() {
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        double pMouseX = click.x();
        double pMouseY = click.y();
        if (!this.nameBox.isFocused() && pMouseY > (double)this.guiTop && pMouseY < (double)(this.guiTop + 14) && pMouseX > (double)this.guiLeft && pMouseX < (double)(this.guiLeft + this.background.getWidth())) {
            this.nameBox.setFocused(true);
            this.nameBox.setHighlightPos(0);
            this.setFocused((GuiEventListener)this.nameBox);
            return true;
        }
        if (this.trainNameBox.active && !this.trainNameBox.isFocused() && pMouseY > (double)(this.guiTop + 45) && pMouseY < (double)(this.guiTop + 58) && pMouseX > (double)(this.guiLeft + 25) && pMouseX < (double)(this.guiLeft + 168)) {
            this.trainNameBox.setFocused(true);
            this.trainNameBox.setHighlightPos(0);
            this.setFocused((GuiEventListener)this.trainNameBox);
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        boolean hitEnter;
        int pKeyCode = input.key();
        boolean bl = hitEnter = this.getFocused() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.isFocused()) {
            this.nameBox.setFocused(false);
            this.syncStationName();
            return true;
        }
        if (hitEnter && this.trainNameBox.isFocused()) {
            this.trainNameBox.setFocused(false);
            this.syncTrainNameAndColor();
            return true;
        }
        return super.keyPressed(input);
    }

    private void syncTrainNameAndColor() {
        Train train = (Train)this.displayedTrain.get();
        if (train != null && !this.trainNameBox.getValue().equals(train.name.getString())) {
            this.minecraft.player.connection.send((Packet)new TrainEditPacket(train.id, this.trainNameBox.getValue(), train.icon.id(), train.mapColorIndex));
        }
    }

    private void syncStationName() {
        if (!this.nameBox.getValue().equals(this.station.name)) {
            this.minecraft.player.connection.send((Packet)StationEditPacket.configure(this.blockEntity.getBlockPos(), false, this.nameBox.getValue(), this.doorControl));
        }
    }

    public void removed() {
        super.removed();
        if (this.nameBox == null || this.trainNameBox == null) {
            return;
        }
        this.minecraft.player.connection.send((Packet)StationEditPacket.configure(this.blockEntity.getBlockPos(), this.switchingToAssemblyMode, this.nameBox.getValue(), this.doorControl));
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            return;
        }
        if (!this.switchingToAssemblyMode) {
            this.minecraft.player.connection.send((Packet)new TrainEditPacket(train.id, this.trainNameBox.getValue(), train.icon.id(), train.mapColorIndex));
        } else {
            this.blockEntity.imminentTrain = null;
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return this.blockEntity.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF;
    }
}

