/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.google.common.base.Objects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.trains.GlobalRailwayManagerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrackTargetingClient {
    static BlockPos lastHovered;
    static boolean lastDirection;
    static EdgePointType<?> lastType;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static TrackTargetingBlockItem.OverlapResult lastResult;
    static TrackGraphLocation lastLocation;

    public static void clientTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        Vec3 lookAngle = player.getLookAngle();
        BlockPos hovered = null;
        boolean direction = false;
        EdgePointType<?> type = null;
        BezierTrackPointLocation hoveredBezier = null;
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof TrackTargetingBlockItem) {
            TrackTargetingBlockItem ttbi = (TrackTargetingBlockItem)item;
            type = ttbi.getType(stack);
        }
        if (type == EdgePointType.SIGNAL) {
            GlobalRailwayManagerClient.tickSignalOverlay(mc);
        }
        boolean alreadySelected = stack.has(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        if (type != null) {
            TrackBlockOutline.BezierPointSelection bezierSelection = TrackBlockOutline.result;
            if (alreadySelected) {
                hovered = (BlockPos)stack.get(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
                direction = (Boolean)stack.getOrDefault(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)false);
                if (stack.has(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER)) {
                    hoveredBezier = (BezierTrackPointLocation)stack.get(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
                }
            } else if (bezierSelection != null) {
                hovered = bezierSelection.blockEntity().getBlockPos();
                hoveredBezier = bezierSelection.loc();
                direction = lookAngle.dot(bezierSelection.direction()) < 0.0;
            } else {
                BlockHitResult blockHitResult;
                BlockPos pos;
                BlockState blockState;
                Block block;
                HitResult hitResult = mc.hitResult;
                if (hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && (block = (blockState = mc.level.getBlockState(pos = (blockHitResult = (BlockHitResult)hitResult).getBlockPos())).getBlock()) instanceof ITrackBlock) {
                    ITrackBlock track = (ITrackBlock)block;
                    direction = track.getNearestTrackAxis((BlockGetter)mc.level, pos, blockState, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
                    hovered = pos;
                }
            }
        }
        if (hovered == null) {
            lastHovered = null;
            lastResult = null;
            lastLocation = null;
            lastHoveredBezierSegment = null;
            return;
        }
        if (Objects.equal(hovered, (Object)lastHovered) && Objects.equal(hoveredBezier, (Object)lastHoveredBezierSegment) && direction == lastDirection && type == lastType) {
            return;
        }
        lastType = type;
        lastHovered = hovered;
        lastDirection = direction;
        lastHoveredBezierSegment = hoveredBezier;
        TrackTargetingBlockItem.withGraphLocation((Level)mc.level, hovered, direction, hoveredBezier, type, (result, location) -> {
            lastResult = result;
            lastLocation = location;
        });
    }

    public static void render(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        Direction.AxisDirection direction;
        if (lastLocation == null || TrackTargetingClient.lastResult.feedback != null) {
            return;
        }
        BlockPos pos = lastHovered;
        Direction.AxisDirection axisDirection = direction = lastDirection ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackTargetingBehaviour.RenderedTrackOverlayType type = lastType == EdgePointType.SIGNAL ? TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL : (lastType == EdgePointType.OBSERVER ? TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER : TrackTargetingBehaviour.RenderedTrackOverlayType.STATION);
        BlockState state = mc.level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            renderer.getRenderState((Level)mc.level, new Vec3((double)pos.getX() - camera.x(), (double)pos.getY() - camera.y(), (double)pos.getZ() - camera.z()), state, pos, direction, lastHoveredBezierSegment, type, 1.0625f).render(ms, buffer);
        }
    }
}

