/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.api.visualization;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.api.internal.FlwApiLink;
import com.zurrtum.create.client.flywheel.api.visual.Effect;
import com.zurrtum.create.client.flywheel.api.visualization.VisualManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface VisualizationManager {
    public static boolean supportsVisualization(@Nullable LevelAccessor level) {
        return FlwApiLink.INSTANCE.supportsVisualization(level);
    }

    @Nullable
    public static VisualizationManager get(@Nullable LevelAccessor level) {
        return FlwApiLink.INSTANCE.getVisualizationManager(level);
    }

    public static VisualizationManager getOrThrow(@Nullable LevelAccessor level) {
        return FlwApiLink.INSTANCE.getVisualizationManagerOrThrow(level);
    }

    public Vec3i renderOrigin();

    public VisualManager<BlockEntity> blockEntities();

    public VisualManager<Entity> entities();

    public VisualManager<Effect> effects();

    public RenderDispatcher renderDispatcher();

    @ApiStatus.NonExtendable
    public static interface RenderDispatcher {
        public void onStartLevelRender(RenderContext var1);

        public void afterEntities(RenderContext var1);

        public void beforeCrumbling(RenderContext var1, Long2ObjectMap<SortedSet<BlockDestructionProgress>> var2);
    }
}

