/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.api.backend.Engine;
import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visualization.VisualEmbedding;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.backend.FlwBackend;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.DrawManager;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerProviderImpl;
import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EmbeddedEnvironment;
import com.zurrtum.create.client.flywheel.backend.engine.embed.Environment;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EnvironmentStorage;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.Uniforms;
import com.zurrtum.create.client.flywheel.backend.gl.GlStateTracker;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class EngineImpl
implements Engine {
    private final DrawManager<? extends AbstractInstancer<?>> drawManager;
    private final int sqrMaxOriginDistance;
    private final EnvironmentStorage environmentStorage;
    private final LightStorage lightStorage;
    private BlockPos renderOrigin = BlockPos.ZERO;

    public EngineImpl(LevelAccessor level, DrawManager<? extends AbstractInstancer<?>> drawManager, int maxOriginDistance) {
        this.drawManager = drawManager;
        this.sqrMaxOriginDistance = maxOriginDistance * maxOriginDistance;
        this.environmentStorage = new EnvironmentStorage();
        this.lightStorage = new LightStorage(level);
    }

    @Override
    public VisualizationContext createVisualizationContext() {
        return new VisualizationContextImpl();
    }

    @Override
    public Plan<RenderContext> createFramePlan() {
        return this.drawManager.createFramePlan().and(this.lightStorage.createFramePlan());
    }

    @Override
    public Vec3i renderOrigin() {
        return this.renderOrigin;
    }

    @Override
    public boolean updateRenderOrigin(Camera camera) {
        double dz;
        double dy;
        Vec3 cameraPos = camera.position();
        double dx = (double)this.renderOrigin.getX() - cameraPos.x;
        double distanceSqr = dx * dx + (dy = (double)this.renderOrigin.getY() - cameraPos.y) * dy + (dz = (double)this.renderOrigin.getZ() - cameraPos.z) * dz;
        if (distanceSqr <= (double)this.sqrMaxOriginDistance) {
            return false;
        }
        this.renderOrigin = BlockPos.containing((Position)cameraPos);
        this.drawManager.onRenderOriginChanged();
        return true;
    }

    @Override
    public void lightSections(LongSet sections) {
        this.lightStorage.sections(sections);
    }

    @Override
    public void onLightUpdate(SectionPos sectionPos, LightLayer layer) {
        this.lightStorage.onLightUpdate(sectionPos.asLong());
    }

    @Override
    public void render(RenderContext context) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            Uniforms.update(context);
            this.environmentStorage.flush();
            this.drawManager.render(this.lightStorage, this.environmentStorage);
        }
        catch (Exception e) {
            FlwBackend.LOGGER.error("Falling back", (Throwable)e);
            this.triggerFallback();
        }
    }

    @Override
    public void renderCrumbling(RenderContext context, List<Engine.CrumblingBlock> crumblingBlocks) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            this.drawManager.renderCrumbling(crumblingBlocks);
        }
        catch (Exception e) {
            FlwBackend.LOGGER.error("Falling back", (Throwable)e);
            this.triggerFallback();
        }
    }

    @Override
    public void delete() {
        this.drawManager.delete();
        this.lightStorage.delete();
        this.environmentStorage.delete();
    }

    private void triggerFallback() {
        this.drawManager.triggerFallback();
    }

    public <I extends Instance> Instancer<I> instancer(Environment environment, InstanceType<I> type, Model model, int bias) {
        return this.drawManager.getInstancer(environment, type, model, bias);
    }

    public EnvironmentStorage environmentStorage() {
        return this.environmentStorage;
    }

    public LightStorage lightStorage() {
        return this.lightStorage;
    }

    private class VisualizationContextImpl
    implements VisualizationContext {
        private final InstancerProviderImpl instancerProvider;

        public VisualizationContextImpl() {
            this.instancerProvider = new InstancerProviderImpl(EngineImpl.this);
        }

        @Override
        public InstancerProvider instancerProvider() {
            return this.instancerProvider;
        }

        @Override
        public Vec3i renderOrigin() {
            return EngineImpl.this.renderOrigin();
        }

        @Override
        public VisualEmbedding createEmbedding(Vec3i renderOrigin) {
            EmbeddedEnvironment out = new EmbeddedEnvironment(EngineImpl.this, renderOrigin);
            EngineImpl.this.environmentStorage.track(out);
            return out;
        }
    }
}

