/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import org.jetbrains.annotations.UnknownNullability;

public class InstanceHandleImpl<I extends Instance>
implements InstanceHandle {
    public @UnknownNullability State<I> state;
    public int index;

    public InstanceHandleImpl(@UnknownNullability State<I> state) {
        this.state = state;
    }

    @Override
    public void setChanged() {
        this.state = this.state.setChanged(this.index);
    }

    @Override
    public void setDeleted() {
        this.state = this.state.setDeleted(this.index);
        this.clear();
    }

    @Override
    public void setVisible(boolean visible) {
        this.state = this.state.setVisible(this, this.index, visible);
    }

    @Override
    public boolean isVisible() {
        return this.state instanceof AbstractInstancer;
    }

    public void clear() {
        this.index = -1;
    }

    public static interface State<I extends Instance> {
        public State<I> setChanged(int var1);

        public State<I> setDeleted(int var1);

        public State<I> setVisible(InstanceHandleImpl<I> var1, int var2, boolean var3);
    }

    public record Deleted<I extends Instance>() implements State<I>
    {
        private static final Deleted<?> INSTANCE = new Deleted();

        public static <I extends Instance> Deleted<I> instance() {
            return INSTANCE;
        }

        @Override
        public State<I> setChanged(int index) {
            return this;
        }

        @Override
        public State<I> setDeleted(int index) {
            return this;
        }

        @Override
        public State<I> setVisible(InstanceHandleImpl<I> handle, int index, boolean visible) {
            return this;
        }
    }

    public record Hidden<I extends Instance>(AbstractInstancer.Recreate<I> recreate, I instance) implements State<I>
    {
        @Override
        public State<I> setChanged(int index) {
            return this;
        }

        @Override
        public State<I> setDeleted(int index) {
            return this;
        }

        @Override
        public State<I> setVisible(InstanceHandleImpl<I> handle, int index, boolean visible) {
            if (!visible) {
                return this;
            }
            AbstractInstancer<I> instancer = this.recreate.recreate();
            return instancer.revealInstance(handle, this.instance);
        }
    }
}

