/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.backend.engine.MaterialEncoder;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EmbeddedEnvironment;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectInstancer;
import org.lwjgl.system.MemoryUtil;

public class IndirectDraw {
    private final IndirectInstancer<?> instancer;
    private final Material material;
    private final MeshPool.PooledMesh mesh;
    private final int bias;
    private final int indexOfMeshInModel;
    private final int packedFogAndCutout;
    private final int packedMaterialProperties;
    private boolean deleted;

    public IndirectDraw(IndirectInstancer<?> instancer, Material material, MeshPool.PooledMesh mesh, int bias, int indexOfMeshInModel) {
        this.instancer = instancer;
        this.material = material;
        this.mesh = mesh;
        this.bias = bias;
        this.indexOfMeshInModel = indexOfMeshInModel;
        mesh.acquire();
        this.packedFogAndCutout = MaterialEncoder.packUberShader(material);
        this.packedMaterialProperties = MaterialEncoder.packProperties(material);
    }

    public boolean deleted() {
        return this.deleted;
    }

    public Material material() {
        return this.material;
    }

    public boolean isEmbedded() {
        return this.instancer.environment instanceof EmbeddedEnvironment;
    }

    public MeshPool.PooledMesh mesh() {
        return this.mesh;
    }

    public int bias() {
        return this.bias;
    }

    public int indexOfMeshInModel() {
        return this.indexOfMeshInModel;
    }

    public void write(long ptr) {
        MemoryUtil.memPutInt((long)ptr, (int)this.mesh.indexCount());
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)this.mesh.firstIndex());
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)this.mesh.baseVertex());
        MemoryUtil.memPutInt((long)(ptr + 16L), (int)this.instancer.baseInstance());
        MemoryUtil.memPutInt((long)(ptr + 20L), (int)this.instancer.modelIndex());
        MemoryUtil.memPutInt((long)(ptr + 24L), (int)this.instancer.environment.matrixIndex());
        MemoryUtil.memPutInt((long)(ptr + 28L), (int)this.packedFogAndCutout);
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)this.packedMaterialProperties);
    }

    public void writeWithOverrides(long ptr, int instanceIndex, Material materialOverride) {
        MemoryUtil.memPutInt((long)ptr, (int)this.mesh.indexCount());
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)1);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)this.mesh.firstIndex());
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)this.mesh.baseVertex());
        MemoryUtil.memPutInt((long)(ptr + 16L), (int)this.instancer.local2GlobalInstanceIndex(instanceIndex));
        MemoryUtil.memPutInt((long)(ptr + 20L), (int)this.instancer.modelIndex());
        MemoryUtil.memPutInt((long)(ptr + 24L), (int)this.instancer.environment.matrixIndex());
        MemoryUtil.memPutInt((long)(ptr + 28L), (int)MaterialEncoder.packUberShader(materialOverride));
        MemoryUtil.memPutInt((long)(ptr + 32L), (int)MaterialEncoder.packProperties(materialOverride));
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.mesh.release();
        this.deleted = true;
    }
}

