/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceWriter;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.InstanceHandleImpl;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerKey;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.IndirectDraw;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.ObjectStorage;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import com.zurrtum.create.client.flywheel.backend.util.AtomicBitSet;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

public class IndirectInstancer<I extends Instance>
extends AbstractInstancer<I> {
    private final long instanceStride;
    private final InstanceWriter<I> writer;
    private final List<IndirectDraw> associatedDraws = new ArrayList<IndirectDraw>();
    private final Vector4fc boundingSphere;
    private final AtomicReference<InstancePage<I>[]> pages = new AtomicReference<InstancePage<I>[]>(IndirectInstancer.pageArray(0));
    private final AtomicInteger instanceCount = new AtomicInteger(0);
    private final AtomicBitSet validityChanged = new AtomicBitSet();
    private final AtomicBitSet contentsChanged = new AtomicBitSet();
    private final AtomicBitSet fullPages = new AtomicBitSet();
    private final AtomicBitSet mergeablePages = new AtomicBitSet();
    public @UnknownNullability ObjectStorage.Mapping mapping;
    private int modelIndex = -1;
    private int baseInstance = -1;

    public IndirectInstancer(InstancerKey<I> key, AbstractInstancer.Recreate<I> recreate) {
        super(key, recreate);
        this.instanceStride = MoreMath.align4(this.type.layout().byteSize());
        this.writer = this.type.writer();
        this.boundingSphere = key.model().boundingSphere();
    }

    private static <I extends Instance> InstancePage<I>[] pageArray(int length) {
        return new InstancePage[length];
    }

    private static <I extends Instance> I[] instanceArray() {
        return new Instance[32];
    }

    private static <I extends Instance> InstanceHandleImpl<I>[] handleArray() {
        return new InstanceHandleImpl[32];
    }

    @Nullable
    public static IndirectInstancer<?> fromState(InstanceHandleImpl.State<?> handle) {
        if (handle instanceof InstancePage) {
            InstancePage instancer = (InstancePage)handle;
            return instancer.parent;
        }
        return null;
    }

    public void addDraw(IndirectDraw draw) {
        this.associatedDraws.add(draw);
    }

    public List<IndirectDraw> draws() {
        return this.associatedDraws;
    }

    public void update(int modelIndex, int baseInstance) {
        boolean sameModelIndex;
        this.baseInstance = baseInstance;
        boolean bl = sameModelIndex = this.modelIndex == modelIndex;
        if (sameModelIndex && this.validityChanged.isEmpty()) {
            return;
        }
        this.modelIndex = modelIndex;
        InstancePage<I>[] pages = this.pages.get();
        this.mapping.updateCount(pages.length);
        if (sameModelIndex) {
            int page = this.validityChanged.nextSetBit(0);
            while (page >= 0 && page < pages.length) {
                this.mapping.updatePage(page, modelIndex, pages[page].valid.get());
                page = this.validityChanged.nextSetBit(page + 1);
            }
        } else {
            for (int i = 0; i < pages.length; ++i) {
                this.mapping.updatePage(i, modelIndex, pages[i].valid.get());
            }
        }
        this.validityChanged.clear();
    }

    public void writeModel(long ptr) {
        MemoryUtil.memPutInt((long)ptr, (int)0);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)this.baseInstance);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)this.environment.matrixIndex());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)this.boundingSphere.x());
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)this.boundingSphere.y());
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)this.boundingSphere.z());
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)this.boundingSphere.w());
    }

    public void uploadInstances(StagingBuffer stagingBuffer, int instanceVbo) {
        if (this.contentsChanged.isEmpty()) {
            return;
        }
        InstancePage<I>[] pages = this.pages.get();
        int page = this.contentsChanged.nextSetBit(0);
        while (page >= 0 && page < pages.length) {
            I[] instances = pages[page].instances;
            long baseByte = this.mapping.page2ByteOffset(page);
            if (baseByte >= 0L) {
                long size = 32L * this.instanceStride;
                long direct = stagingBuffer.reserveForCopy(size, instanceVbo, baseByte);
                if (direct != 0L) {
                    for (Object instance : instances) {
                        if (instance != null) {
                            this.writer.write(direct, instance);
                        }
                        direct += this.instanceStride;
                    }
                } else {
                    MemoryBlock block = stagingBuffer.getScratch(size);
                    long ptr = block.ptr();
                    for (Object instance : instances) {
                        if (instance != null) {
                            this.writer.write(ptr, instance);
                        }
                        ptr += this.instanceStride;
                    }
                    stagingBuffer.enqueueCopy(block.ptr(), size, instanceVbo, baseByte);
                }
            }
            page = this.contentsChanged.nextSetBit(page + 1);
        }
        this.contentsChanged.clear();
    }

    @Override
    public void parallelUpdate() {
        int next;
        InstancePage<I>[] pages = this.pages.get();
        this.mergeablePages.clear(pages.length, this.mergeablePages.currentCapacity());
        int page = 0;
        while (this.mergeablePages.cardinality() > 1 && (page = this.mergeablePages.nextSetBit(page)) >= 0 && (next = this.mergeablePages.nextSetBit(page + 1)) >= 0) {
            pages[page].takeFrom(pages[next]);
        }
    }

    private static boolean isFull(int valid) {
        return valid == -1;
    }

    private static boolean isEmpty(int valid) {
        return valid == 0;
    }

    private static boolean isMergeable(int valid) {
        return !IndirectInstancer.isEmpty(valid) && Integer.bitCount(valid) <= 16;
    }

    @Override
    public void delete() {
        for (IndirectDraw draw : this.draws()) {
            draw.delete();
        }
        this.mapping.delete();
    }

    public int modelIndex() {
        return this.modelIndex;
    }

    public int baseInstance() {
        return this.baseInstance;
    }

    public int local2GlobalInstanceIndex(int instanceIndex) {
        return this.mapping.objectIndex2GlobalIndex(instanceIndex);
    }

    @Override
    public I createInstance() {
        InstanceHandleImpl handle = new InstanceHandleImpl(null);
        Object instance = this.type.create(handle);
        this.addInner(instance, handle);
        return instance;
    }

    @Override
    public InstanceHandleImpl.State<I> revealInstance(InstanceHandleImpl<I> handle, I instance) {
        this.addInner(instance, handle);
        return handle.state;
    }

    @Override
    public void stealInstance(@Nullable I instance) {
        InstanceHandleImpl.Hidden hidden;
        if (instance == null) {
            return;
        }
        InstanceHandle instanceHandle = instance.handle();
        if (!(instanceHandle instanceof InstanceHandleImpl)) {
            return;
        }
        InstanceHandleImpl handle = (InstanceHandleImpl)instanceHandle;
        if (handle.state instanceof InstanceHandleImpl.Deleted) {
            return;
        }
        InstanceHandleImpl.State state = handle.state;
        if (state instanceof InstanceHandleImpl.Hidden && this.recreate.equals((hidden = (InstanceHandleImpl.Hidden)state).recreate())) {
            return;
        }
        state = handle.state;
        if (state instanceof InstancePage) {
            InstancePage other = (InstancePage)state;
            if (other.parent == this) {
                return;
            }
            other.setDeleted(handle.index);
            this.addInner(instance, handle);
        } else if (handle.state instanceof InstanceHandleImpl.Hidden) {
            handle.state = new InstanceHandleImpl.Hidden<I>(this.recreate, instance);
        }
    }

    private void addInner(I instance, InstanceHandleImpl<I> handle) {
        InstancePage<I>[] pages;
        do {
            pages = this.pages.get();
            int i = this.fullPages.nextClearBit(0);
            while (i < pages.length) {
                if (pages[i].add(instance, handle)) {
                    return;
                }
                i = this.fullPages.nextClearBit(i + 1);
            }
            int desiredLength = pages.length + 1;
            while (pages.length < desiredLength) {
                InstancePage<I>[] newPages = IndirectInstancer.pageArray(desiredLength);
                System.arraycopy(pages, 0, newPages, 0, pages.length);
                newPages[pages.length] = new InstancePage(this, pages.length);
                if (this.pages.compareAndSet(pages, newPages)) {
                    pages = newPages;
                    continue;
                }
                pages = this.pages.get();
            }
        } while (!pages[pages.length - 1].add(instance, handle));
    }

    @Override
    public int instanceCount() {
        return this.instanceCount.get();
    }

    @Override
    public void clear() {
        this.pages.set(IndirectInstancer.pageArray(0));
        this.contentsChanged.clear();
        this.validityChanged.clear();
        this.fullPages.clear();
        this.mergeablePages.clear();
    }

    private static final class InstancePage<I extends Instance>
    implements InstanceHandleImpl.State<I> {
        private final IndirectInstancer<I> parent;
        private final int pageNo;
        private final I[] instances;
        private final InstanceHandleImpl<I>[] handles;
        private final AtomicInteger valid;

        private InstancePage(IndirectInstancer<I> parent, int pageNo) {
            this.parent = parent;
            this.pageNo = pageNo;
            this.instances = IndirectInstancer.instanceArray();
            this.handles = IndirectInstancer.handleArray();
            this.valid = new AtomicInteger(0);
        }

        public boolean add(I instance, InstanceHandleImpl<I> handle) {
            int index;
            int newValue;
            int currentValue;
            do {
                if (!IndirectInstancer.isFull(currentValue = this.valid.get())) continue;
                return false;
            } while (!this.valid.compareAndSet(currentValue, newValue = currentValue | 1 << (index = Integer.numberOfTrailingZeros(~currentValue))));
            this.instances[index] = instance;
            this.handles[index] = handle;
            handle.state = this;
            handle.index = this.local2HandleIndex(index);
            this.parent.contentsChanged.set(this.pageNo);
            this.parent.validityChanged.set(this.pageNo);
            if (IndirectInstancer.isFull(newValue)) {
                this.parent.fullPages.set(this.pageNo);
            }
            if (IndirectInstancer.isMergeable(newValue)) {
                this.parent.mergeablePages.set(this.pageNo);
            }
            this.parent.instanceCount.incrementAndGet();
            return true;
        }

        private int local2HandleIndex(int index) {
            return (this.pageNo << 5) + index;
        }

        @Override
        public InstanceHandleImpl.State<I> setChanged(int index) {
            this.parent.contentsChanged.set(this.pageNo);
            return this;
        }

        @Override
        public InstanceHandleImpl.State<I> setDeleted(int index) {
            int localIndex = index % 32;
            this.clear(localIndex);
            return InstanceHandleImpl.Deleted.instance();
        }

        @Override
        public InstanceHandleImpl.State<I> setVisible(InstanceHandleImpl<I> handle, int index, boolean visible) {
            if (visible) {
                return this;
            }
            int localIndex = index % 32;
            I out = this.instances[localIndex];
            this.clear(localIndex);
            return new InstanceHandleImpl.Hidden<I>(this.parent.recreate, out);
        }

        private void clear(int localIndex) {
            int newValue;
            int currentValue;
            this.instances[localIndex] = null;
            this.handles[localIndex] = null;
            while (!this.valid.compareAndSet(currentValue = this.valid.get(), newValue = currentValue & ~(1 << localIndex))) {
            }
            this.parent.validityChanged.set(this.pageNo);
            if (IndirectInstancer.isMergeable(newValue)) {
                this.parent.mergeablePages.set(this.pageNo);
            }
            this.parent.fullPages.clear(this.pageNo);
            this.parent.instanceCount.decrementAndGet();
        }

        private void takeFrom(InstancePage<I> other) {
            int valid = this.valid.get();
            if (IndirectInstancer.isFull(valid)) {
                this.parent.mergeablePages.clear(this.pageNo);
                return;
            }
            int otherValid = other.valid.get();
            for (int i = 0; i < 32; ++i) {
                int mask = 1 << i;
                if ((otherValid & mask) == 0) continue;
                int writePos = Integer.numberOfTrailingZeros(~valid);
                this.instances[writePos] = other.instances[i];
                this.handles[writePos] = other.handles[i];
                this.handles[writePos].state = this;
                this.handles[writePos].index = this.local2HandleIndex(writePos);
                otherValid &= ~mask;
                other.handles[i] = null;
                other.instances[i] = null;
                if (IndirectInstancer.isFull(valid |= 1 << writePos)) break;
            }
            this.valid.set(valid);
            other.valid.set(otherValid);
            this.parent.mergeablePages.set(this.pageNo, IndirectInstancer.isMergeable(valid));
            this.parent.contentsChanged.set(this.pageNo);
            this.parent.validityChanged.set(this.pageNo);
            this.parent.contentsChanged.clear(other.pageNo);
            this.parent.validityChanged.set(other.pageNo);
            this.parent.mergeablePages.clear(other.pageNo);
            if (IndirectInstancer.isFull(valid)) {
                this.parent.fullPages.set(this.pageNo);
            }
        }
    }
}

