/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.zurrtum.create.client.flywheel.backend.engine.CpuArena;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EnvironmentStorage;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.ResizableStorageArray;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.StagingBuffer;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryUtil;

public class MatrixBuffer {
    private final ResizableStorageArray matrices = new ResizableStorageArray(112L);

    public void flush(StagingBuffer stagingBuffer, EnvironmentStorage environmentStorage) {
        CpuArena arena = environmentStorage.arena;
        int capacity = arena.capacity();
        if (capacity == 0) {
            return;
        }
        this.matrices.ensureCapacity(capacity);
        stagingBuffer.enqueueCopy(arena.byteCapacity(), this.matrices.handle(), 0L, ptr -> MemoryUtil.memCopy((long)arena.indexToPointer(0), (long)ptr, (long)arena.byteCapacity()));
    }

    public void bind() {
        if (this.matrices.capacity() == 0L) {
            return;
        }
        GL46.glBindBufferRange((int)37074, (int)7, (int)this.matrices.handle(), (long)0L, (long)this.matrices.byteCapacity());
    }

    public void delete() {
        this.matrices.delete();
    }
}

