/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.instancing;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.backend.engine.GroupKey;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.engine.instancing.InstancedInstancer;
import com.zurrtum.create.client.flywheel.backend.gl.TextureBuffer;

public class InstancedDraw {
    public final GroupKey<?> groupKey;
    private final InstancedInstancer<?> instancer;
    private final MeshPool.PooledMesh mesh;
    private final Material material;
    private final int bias;
    private final int indexOfMeshInModel;
    private boolean deleted;

    public InstancedDraw(InstancedInstancer<?> instancer, MeshPool.PooledMesh mesh, GroupKey<?> groupKey, Material material, int bias, int indexOfMeshInModel) {
        this.instancer = instancer;
        this.mesh = mesh;
        this.groupKey = groupKey;
        this.material = material;
        this.bias = bias;
        this.indexOfMeshInModel = indexOfMeshInModel;
        mesh.acquire();
    }

    public int bias() {
        return this.bias;
    }

    public int indexOfMeshInModel() {
        return this.indexOfMeshInModel;
    }

    public Material material() {
        return this.material;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public MeshPool.PooledMesh mesh() {
        return this.mesh;
    }

    public void render(TextureBuffer buffer) {
        if (this.mesh.isInvalid()) {
            return;
        }
        this.instancer.bind(buffer);
        this.mesh.draw(this.instancer.instanceCount());
    }

    public void renderOne(TextureBuffer buffer) {
        if (this.mesh.isInvalid()) {
            return;
        }
        this.instancer.bind(buffer);
        this.mesh.draw(1);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.mesh.release();
        this.deleted = true;
    }
}

