/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.mojang.blaze3d.platform.Lighting;
import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformWriter;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.attribute.EnvironmentAttributeProbe;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.MoonPhase;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;

public final class LevelUniforms
extends UniformWriter {
    private static final int SIZE = 112;
    static final UniformBuffer BUFFER = new UniformBuffer(4, 112);
    static final Map<Lighting.Entry, float[]> CACHE = new EnumMap<Lighting.Entry, float[]>(Lighting.Entry.class);
    public static float[] LIGHT_DIRECTION;

    private LevelUniforms() {
    }

    public static void update(Lighting.Entry type, Vector3f light0Diffusion, Vector3f light1Diffusion) {
        float[] diffusions = CACHE.computeIfAbsent(type, t -> new float[6]);
        diffusions[0] = light0Diffusion.x;
        diffusions[1] = light0Diffusion.y;
        diffusions[2] = light0Diffusion.z;
        diffusions[3] = light1Diffusion.x;
        diffusions[4] = light1Diffusion.y;
        diffusions[5] = light1Diffusion.z;
    }

    public static void set(Lighting.Entry type) {
        LIGHT_DIRECTION = CACHE.computeIfAbsent(type, t -> new float[6]);
    }

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        ClientLevel level = context.level();
        float partialTick = context.partialTick();
        Camera camera = context.camera();
        EnvironmentAttributeProbe attributeProbe = camera.attributeProbe();
        int skyColor = (Integer)attributeProbe.getValue(EnvironmentAttributes.SKY_COLOR, partialTick);
        int cloudColor = (Integer)camera.attributeProbe().getValue(EnvironmentAttributes.CLOUD_COLOR, partialTick);
        ptr = LevelUniforms.writeVec4(ptr, ARGB.redFloat((int)skyColor), ARGB.greenFloat((int)skyColor), ARGB.blueFloat((int)skyColor), 1.0f);
        ptr = LevelUniforms.writeVec4(ptr, ARGB.redFloat((int)cloudColor), ARGB.greenFloat((int)cloudColor), ARGB.blueFloat((int)cloudColor), 1.0f);
        ptr = LevelUniforms.writeVec3(ptr, LIGHT_DIRECTION[0], LIGHT_DIRECTION[1], LIGHT_DIRECTION[2]);
        ptr = LevelUniforms.writeVec3(ptr, LIGHT_DIRECTION[3], LIGHT_DIRECTION[4], LIGHT_DIRECTION[5]);
        long dayTime = level.getDayTime();
        long levelDay = dayTime / 24000L;
        float timeOfDay = (float)(dayTime - levelDay * 24000L) / 24000.0f;
        ptr = LevelUniforms.writeInt(ptr, (int)(levelDay % Integer.MAX_VALUE));
        ptr = LevelUniforms.writeFloat(ptr, timeOfDay);
        ptr = LevelUniforms.writeInt(ptr, level.dimensionType().hasSkyLight() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, ((Float)attributeProbe.getValue(EnvironmentAttributes.SUN_ANGLE, partialTick)).floatValue() * ((float)Math.PI / 180));
        MoonPhase moonPhase = (MoonPhase)attributeProbe.getValue(EnvironmentAttributes.MOON_PHASE, partialTick);
        ptr = LevelUniforms.writeFloat(ptr, DimensionType.MOON_BRIGHTNESS_PER_PHASE[moonPhase.index()]);
        ptr = LevelUniforms.writeInt(ptr, moonPhase.index());
        ptr = LevelUniforms.writeInt(ptr, level.isRaining() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.getRainLevel(partialTick));
        ptr = LevelUniforms.writeInt(ptr, level.isThundering() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.getThunderLevel(partialTick));
        ptr = LevelUniforms.writeFloat(ptr, level.getSkyDarken());
        ptr = LevelUniforms.writeInt(ptr, level.dimensionType().cardinalLightType() == DimensionType.CardinalLightType.NETHER ? 1 : 0);
        ResourceKey dimension = level.dimension();
        int dimensionId = Level.OVERWORLD.equals(dimension) ? 0 : (Level.NETHER.equals(dimension) ? 1 : (Level.END.equals(dimension) ? 2 : -1));
        ptr = LevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

