/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBuffer;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferUsage;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL32;

public class UniformBuffer {
    private final int index;
    private final MemoryBlock clientBuffer;
    @Nullable
    private GlBuffer buffer;
    private boolean needsUpload;

    public UniformBuffer(int index, int size) {
        this.index = index;
        this.clientBuffer = MemoryBlock.malloc(MoreMath.align16(size));
        this.clientBuffer.clear();
    }

    public long ptr() {
        return this.clientBuffer.ptr();
    }

    public void markDirty() {
        this.needsUpload = true;
    }

    public void clear() {
        this.clientBuffer.clear();
        this.markDirty();
    }

    public void bind() {
        if (this.buffer == null) {
            this.buffer = new GlBuffer(GlBufferUsage.DYNAMIC_DRAW);
            this.needsUpload = true;
        }
        if (this.needsUpload) {
            this.buffer.upload(this.clientBuffer);
            this.needsUpload = false;
        }
        GL32.glBindBufferRange((int)35345, (int)this.index, (int)this.buffer.handle(), (long)0L, (long)this.clientBuffer.size());
    }

    public void delete() {
        if (this.buffer != null) {
            this.buffer.delete();
            this.buffer = null;
        }
    }
}

