/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.backend.glsl.error.ErrorBuilder;
import com.zurrtum.create.client.flywheel.backend.glsl.span.Span;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.IdentifierException;
import net.minecraft.resources.Identifier;

public sealed interface LoadError {
    public ErrorBuilder generateMessage();

    public record MalformedInclude(IdentifierException exception) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error(this.exception.toString());
        }
    }

    public record ResourceError(Identifier location) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error("\"" + String.valueOf(this.location) + "\" was not found");
        }
    }

    public record IOError(Identifier location, IOException exception) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            if (this.exception instanceof FileNotFoundException) {
                return ErrorBuilder.create().error("\"" + String.valueOf(this.location) + "\" was not found");
            }
            return ErrorBuilder.create().error("could not load \"" + String.valueOf(this.location) + "\" due to an IO error").note(this.exception.toString());
        }
    }

    public record IncludeError(Identifier location, List<Pair<Span, LoadError>> innerErrors) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            ErrorBuilder out = ErrorBuilder.create().error("could not load \"" + String.valueOf(this.location) + "\"").pointAtFile(this.location);
            for (Pair<Span, LoadError> innerError : this.innerErrors) {
                ErrorBuilder err = ((LoadError)innerError.getSecond()).generateMessage();
                out.pointAt((Span)innerError.getFirst()).nested(err);
            }
            return out;
        }
    }

    public record CircularDependency(Identifier offender, List<Identifier> stack) implements LoadError
    {
        public String format() {
            return this.stack.stream().dropWhile(l -> !l.equals((Object)this.offender)).map(Identifier::toString).collect(Collectors.joining(" -> "));
        }

        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error("files are circularly dependent").note(this.format());
        }
    }
}

