/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl.generate;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.BinOp;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface GlslExpr {
    public static Variable variable(String name) {
        return new Variable(name);
    }

    public static FunctionCall call(String functionName, GlslExpr ... args) {
        return new FunctionCall(functionName, List.of(args));
    }

    public static FunctionCall call(String functionName, Collection<? extends GlslExpr> args) {
        return new FunctionCall(functionName, args);
    }

    public static FunctionCall0 call(String functionName) {
        return new FunctionCall0(functionName);
    }

    public static GlslExpr intLiteral(int expr) {
        return new RawLiteral(Integer.toString(expr));
    }

    public static GlslExpr uintLiteral(int expr) {
        return new RawLiteral(Integer.toUnsignedString(expr) + "u");
    }

    public static GlslExpr uintHexLiteral(int expr) {
        return new RawLiteral("0x" + Integer.toHexString(expr) + "u");
    }

    public static GlslExpr boolLiteral(boolean expr) {
        return new RawLiteral(Boolean.toString(expr));
    }

    public static GlslExpr floatLiteral(float expr) {
        return new RawLiteral(Float.toString(expr));
    }

    default public FunctionCall callFunction(String name) {
        return new FunctionCall(name, this);
    }

    default public FunctionCall cast(String name) {
        return new FunctionCall(name, this);
    }

    default public Swizzle swizzle(String selection) {
        return new Swizzle(this, selection);
    }

    default public Access access(String member) {
        return new Access(this, member);
    }

    default public GlslExpr transform(Function<GlslExpr, GlslExpr> f) {
        return f.apply(this);
    }

    default public GlslExpr div(float v) {
        return new Binary(this, GlslExpr.floatLiteral(v), BinOp.DIVIDE);
    }

    default public GlslExpr sub(int v) {
        return new Binary(this, GlslExpr.uintLiteral(v), BinOp.SUBTRACT);
    }

    default public GlslExpr rsh(int by) {
        if (by == 0) {
            return this;
        }
        return new Binary(this, GlslExpr.uintLiteral(by), BinOp.RIGHT_SHIFT);
    }

    default public GlslExpr and(int mask) {
        return new Binary(this, GlslExpr.uintHexLiteral(mask), BinOp.BITWISE_AND);
    }

    default public GlslExpr xor(int mask) {
        return new Binary(this, GlslExpr.uintHexLiteral(mask), BinOp.BITWISE_XOR);
    }

    default public GlslExpr clamp(float from, float to) {
        return new Clamp(this, GlslExpr.floatLiteral(from), GlslExpr.floatLiteral(to));
    }

    public String prettyPrint();

    public record Variable(String name) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return this.name;
        }
    }

    public record FunctionCall(String name, Collection<? extends GlslExpr> args) implements GlslExpr
    {
        public FunctionCall(String name, GlslExpr target) {
            this(name, (Collection<? extends GlslExpr>)ImmutableList.of((Object)target));
        }

        @Override
        public String prettyPrint() {
            String args = this.args.stream().map(GlslExpr::prettyPrint).collect(Collectors.joining(", "));
            return this.name + "(" + args + ")";
        }
    }

    public record FunctionCall0(String name) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return this.name + "()";
        }
    }

    public record RawLiteral(String value) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return this.value;
        }
    }

    public record Swizzle(GlslExpr target, String selection) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return this.target.prettyPrint() + "." + this.selection;
        }
    }

    public record Access(GlslExpr target, String argName) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return this.target.prettyPrint() + "." + this.argName;
        }
    }

    public record Binary(GlslExpr lhs, GlslExpr rhs, BinOp op) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return "(" + this.lhs.prettyPrint() + " " + this.op.op + " " + this.rhs.prettyPrint() + ")";
        }
    }

    public record Clamp(GlslExpr value, GlslExpr from, GlslExpr to) implements GlslExpr
    {
        @Override
        public String prettyPrint() {
            return "clamp(" + this.value.prettyPrint() + ", " + this.from.prettyPrint() + ", " + this.to.prettyPrint() + ")";
        }
    }
}

