/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.instance;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.instance.InstanceWriter;
import com.zurrtum.create.client.flywheel.api.layout.Layout;
import java.util.Objects;
import net.minecraft.resources.Identifier;

public final class SimpleInstanceType<I extends Instance>
implements InstanceType<I> {
    private final Factory<I> factory;
    private final Layout layout;
    private final InstanceWriter<I> writer;
    private final Identifier vertexShader;
    private final Identifier cullShader;

    public SimpleInstanceType(Factory<I> factory, Layout layout, InstanceWriter<I> writer, Identifier vertexShader, Identifier cullShader) {
        this.factory = factory;
        this.layout = layout;
        this.writer = writer;
        this.vertexShader = vertexShader;
        this.cullShader = cullShader;
    }

    public static <I extends Instance> Builder<I> builder(Factory<I> factory) {
        return new Builder<I>(factory);
    }

    @Override
    public I create(InstanceHandle handle) {
        return this.factory.create(this, handle);
    }

    @Override
    public Layout layout() {
        return this.layout;
    }

    @Override
    public InstanceWriter<I> writer() {
        return this.writer;
    }

    @Override
    public Identifier vertexShader() {
        return this.vertexShader;
    }

    @Override
    public Identifier cullShader() {
        return this.cullShader;
    }

    @FunctionalInterface
    public static interface Factory<I extends Instance> {
        public I create(InstanceType<I> var1, InstanceHandle var2);
    }

    public static final class Builder<I extends Instance> {
        private final Factory<I> factory;
        private Layout layout;
        private InstanceWriter<I> writer;
        private Identifier vertexShader;
        private Identifier cullShader;

        public Builder(Factory<I> factory) {
            this.factory = factory;
        }

        public Builder<I> layout(Layout layout) {
            this.layout = layout;
            return this;
        }

        public Builder<I> writer(InstanceWriter<I> writer) {
            this.writer = writer;
            return this;
        }

        public Builder<I> vertexShader(Identifier vertexShader) {
            this.vertexShader = vertexShader;
            return this;
        }

        public Builder<I> cullShader(Identifier cullShader) {
            this.cullShader = cullShader;
            return this;
        }

        public SimpleInstanceType<I> build() {
            Objects.requireNonNull(this.layout);
            Objects.requireNonNull(this.writer);
            Objects.requireNonNull(this.vertexShader);
            Objects.requireNonNull(this.cullShader);
            return new SimpleInstanceType<I>(this.factory, this.layout, this.writer, this.vertexShader, this.cullShader);
        }
    }
}

