/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.material;

import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.CutoutShader;
import com.zurrtum.create.client.flywheel.api.material.DepthTest;
import com.zurrtum.create.client.flywheel.api.material.FogShader;
import com.zurrtum.create.client.flywheel.api.material.LightShader;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.MaterialShaders;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.material.WriteMask;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.FogShaders;
import com.zurrtum.create.client.flywheel.lib.material.LightShaders;
import com.zurrtum.create.client.flywheel.lib.material.StandardMaterialShaders;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.Identifier;

public class SimpleMaterial
implements Material {
    protected final MaterialShaders shaders;
    protected final FogShader fog;
    protected final CutoutShader cutout;
    protected final LightShader light;
    protected final Identifier texture;
    protected final boolean blur;
    protected final boolean mipmap;
    protected final boolean backfaceCulling;
    protected final boolean polygonOffset;
    protected final DepthTest depthTest;
    protected final Transparency transparency;
    protected final WriteMask writeMask;
    protected final boolean useOverlay;
    protected final boolean useLight;
    protected final CardinalLightingMode cardinalLightingMode;

    protected SimpleMaterial(Builder builder) {
        this.shaders = builder.shaders();
        this.fog = builder.fog();
        this.cutout = builder.cutout();
        this.light = builder.light();
        this.texture = builder.texture();
        this.blur = builder.blur();
        this.mipmap = builder.mipmap();
        this.backfaceCulling = builder.backfaceCulling();
        this.polygonOffset = builder.polygonOffset();
        this.depthTest = builder.depthTest();
        this.transparency = builder.transparency();
        this.writeMask = builder.writeMask();
        this.useOverlay = builder.useOverlay();
        this.useLight = builder.useLight();
        this.cardinalLightingMode = builder.cardinalLightingMode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderOf(Material material) {
        return new Builder(material);
    }

    @Override
    public MaterialShaders shaders() {
        return this.shaders;
    }

    @Override
    public FogShader fog() {
        return this.fog;
    }

    @Override
    public CutoutShader cutout() {
        return this.cutout;
    }

    @Override
    public LightShader light() {
        return this.light;
    }

    @Override
    public Identifier texture() {
        return this.texture;
    }

    @Override
    public boolean blur() {
        return this.blur;
    }

    @Override
    public boolean mipmap() {
        return this.mipmap;
    }

    @Override
    public boolean backfaceCulling() {
        return this.backfaceCulling;
    }

    @Override
    public boolean polygonOffset() {
        return this.polygonOffset;
    }

    @Override
    public DepthTest depthTest() {
        return this.depthTest;
    }

    @Override
    public Transparency transparency() {
        return this.transparency;
    }

    @Override
    public WriteMask writeMask() {
        return this.writeMask;
    }

    @Override
    public boolean useOverlay() {
        return this.useOverlay;
    }

    @Override
    public boolean useLight() {
        return this.useLight;
    }

    @Override
    public CardinalLightingMode cardinalLightingMode() {
        return this.cardinalLightingMode;
    }

    public static class Builder
    implements Material {
        protected MaterialShaders shaders;
        protected FogShader fog;
        protected CutoutShader cutout;
        protected LightShader light;
        protected Identifier texture;
        protected boolean blur;
        protected boolean mipmap;
        protected boolean backfaceCulling;
        protected boolean polygonOffset;
        protected DepthTest depthTest;
        protected Transparency transparency;
        protected WriteMask writeMask;
        protected boolean useOverlay;
        protected boolean useLight;
        protected CardinalLightingMode cardinalLightingMode;

        public Builder() {
            this.shaders = StandardMaterialShaders.DEFAULT;
            this.fog = FogShaders.LINEAR;
            this.cutout = CutoutShaders.OFF;
            this.light = LightShaders.SMOOTH_WHEN_EMBEDDED;
            this.texture = TextureAtlas.LOCATION_BLOCKS;
            this.blur = false;
            this.mipmap = true;
            this.backfaceCulling = true;
            this.polygonOffset = false;
            this.depthTest = DepthTest.LEQUAL;
            this.transparency = Transparency.OPAQUE;
            this.writeMask = WriteMask.COLOR_DEPTH;
            this.useOverlay = true;
            this.useLight = true;
            this.cardinalLightingMode = CardinalLightingMode.ENTITY;
        }

        public Builder(Material material) {
            this.copyFrom(material);
        }

        public Builder copyFrom(Material material) {
            this.shaders = material.shaders();
            this.fog = material.fog();
            this.cutout = material.cutout();
            this.light = material.light();
            this.texture = material.texture();
            this.blur = material.blur();
            this.mipmap = material.mipmap();
            this.backfaceCulling = material.backfaceCulling();
            this.polygonOffset = material.polygonOffset();
            this.depthTest = material.depthTest();
            this.transparency = material.transparency();
            this.writeMask = material.writeMask();
            this.useOverlay = material.useOverlay();
            this.useLight = material.useLight();
            this.cardinalLightingMode = material.cardinalLightingMode();
            return this;
        }

        public Builder shaders(MaterialShaders value) {
            this.shaders = value;
            return this;
        }

        public Builder fog(FogShader value) {
            this.fog = value;
            return this;
        }

        public Builder cutout(CutoutShader value) {
            this.cutout = value;
            return this;
        }

        public Builder light(LightShader value) {
            this.light = value;
            return this;
        }

        public Builder texture(Identifier value) {
            this.texture = value;
            return this;
        }

        public Builder blur(boolean value) {
            this.blur = value;
            return this;
        }

        public Builder mipmap(boolean value) {
            this.mipmap = value;
            return this;
        }

        public Builder backfaceCulling(boolean value) {
            this.backfaceCulling = value;
            return this;
        }

        public Builder polygonOffset(boolean value) {
            this.polygonOffset = value;
            return this;
        }

        public Builder depthTest(DepthTest value) {
            this.depthTest = value;
            return this;
        }

        public Builder transparency(Transparency value) {
            this.transparency = value;
            return this;
        }

        public Builder writeMask(WriteMask value) {
            this.writeMask = value;
            return this;
        }

        public Builder useOverlay(boolean value) {
            this.useOverlay = value;
            return this;
        }

        public Builder useLight(boolean value) {
            this.useLight = value;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder diffuse(boolean value) {
            return this.cardinalLightingMode(value ? CardinalLightingMode.ENTITY : CardinalLightingMode.OFF);
        }

        public Builder cardinalLightingMode(CardinalLightingMode value) {
            this.cardinalLightingMode = value;
            return this;
        }

        @Override
        public MaterialShaders shaders() {
            return this.shaders;
        }

        @Override
        public FogShader fog() {
            return this.fog;
        }

        @Override
        public CutoutShader cutout() {
            return this.cutout;
        }

        @Override
        public LightShader light() {
            return this.light;
        }

        @Override
        public Identifier texture() {
            return this.texture;
        }

        @Override
        public boolean blur() {
            return this.blur;
        }

        @Override
        public boolean mipmap() {
            return this.mipmap;
        }

        @Override
        public boolean backfaceCulling() {
            return this.backfaceCulling;
        }

        @Override
        public boolean polygonOffset() {
            return this.polygonOffset;
        }

        @Override
        public DepthTest depthTest() {
            return this.depthTest;
        }

        @Override
        public Transparency transparency() {
            return this.transparency;
        }

        @Override
        public WriteMask writeMask() {
            return this.writeMask;
        }

        @Override
        public boolean useOverlay() {
            return this.useOverlay;
        }

        @Override
        public boolean useLight() {
            return this.useLight;
        }

        @Override
        public CardinalLightingMode cardinalLightingMode() {
            return this.cardinalLightingMode;
        }

        public SimpleMaterial build() {
            return new SimpleMaterial(this);
        }
    }
}

