/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.memory;

import com.zurrtum.create.client.flywheel.lib.memory.AbstractMemoryBlockImpl;
import com.zurrtum.create.client.flywheel.lib.memory.FlwMemoryTracker;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;

class MemoryBlockImpl
extends AbstractMemoryBlockImpl {
    static final boolean DEBUG_MEMORY_SAFETY = System.getProperty("flw.debugMemorySafety") != null;

    MemoryBlockImpl(long ptr, long size) {
        super(ptr, size);
    }

    @Override
    public boolean isTracked() {
        return false;
    }

    @Override
    public MemoryBlock realloc(long size) {
        this.assertAllocated();
        MemoryBlockImpl block = new MemoryBlockImpl(FlwMemoryTracker.realloc(this.ptr, size), size);
        FlwMemoryTracker._allocCpuMemory(block.size());
        this.freeInner();
        return block;
    }

    static MemoryBlock malloc(long size) {
        MemoryBlockImpl block = new MemoryBlockImpl(FlwMemoryTracker.malloc(size), size);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }

    static MemoryBlock calloc(long num, long size) {
        MemoryBlockImpl block = new MemoryBlockImpl(FlwMemoryTracker.calloc(num, size), num * size);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }
}

