/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockModelBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public final class Models {
    private static final RendererReloadCache<BlockState, Model> BLOCK_STATE = new RendererReloadCache<BlockState, Model>(it -> new BlockModelBuilder(SinglePosVirtualBlockGetter.createFullDark().blockState((BlockState)it), List.of(BlockPos.ZERO)).build());
    private static final RendererReloadCache<PartialModel, Model> PARTIAL = new RendererReloadCache<PartialModel, Model>(it -> new BakedModelBuilder(it.get()).build());
    private static final RendererReloadCache<TransformedPartial<?>, Model> TRANSFORMED_PARTIAL = new RendererReloadCache<TransformedPartial, Model>(TransformedPartial::create);

    private Models() {
    }

    public static Model block(BlockState state) {
        return BLOCK_STATE.get(state);
    }

    public static Model partial(PartialModel partial) {
        return PARTIAL.get(partial);
    }

    public static <T> Model partial(PartialModel partial, T key, BiConsumer<T, PoseStack> transformer) {
        return TRANSFORMED_PARTIAL.get(new TransformedPartial<T>(partial, key, transformer));
    }

    public static Model partial(PartialModel partial, Direction dir) {
        return Models.partial(partial, dir, Models::rotateAboutCenterToFace);
    }

    private static void rotateAboutCenterToFace(Direction facing, PoseStack stack) {
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(stack).center()).rotateToFace(facing.getOpposite())).uncenter();
    }

    private record TransformedPartial<T>(PartialModel partial, T key, BiConsumer<T, PoseStack> transformer) {
        private Model create() {
            PoseStack stack = new PoseStack();
            this.transformer.accept(this.key, stack);
            return new BakedModelBuilder(this.partial.get()).poseStack(stack).build();
        }
    }
}

