/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshEmitter;
import com.zurrtum.create.client.flywheel.lib.model.baked.TransformingVertexConsumer;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.LayerBakedModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

final class BakedModelBufferer {
    static final ChunkSectionLayer[] CHUNK_LAYERS = ChunkSectionLayer.values();
    static final Map<ChunkSectionLayer, Integer> CHUNK_LAYERS_INDEX = new HashMap<ChunkSectionLayer, Integer>();
    static final int CHUNK_LAYER_AMOUNT = CHUNK_LAYERS.length;
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS;

    private BakedModelBufferer() {
    }

    public static void bufferModel(SimpleModelWrapper model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, ResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        MeshEmitter[] emitters = objects.emitters;
        ModelBlockRenderer blockRenderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        ChunkSectionLayer renderType = LayerBakedModel.getBlockRenderLayer(model, (Supplier<ChunkSectionLayer>)((Supplier)() -> ItemBlockRenderTypes.getChunkRenderType((BlockState)state)));
        MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(renderType)];
        emitter.prepare(resultConsumer);
        poseStack.pushPose();
        blockRenderer.tesselateBlock(level, List.of(model), state, pos, poseStack, (VertexConsumer)emitter, false, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        emitter.end();
    }

    public static void bufferModel(BlockStateModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, ResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        RandomSource random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        ModelBlockRenderer blockRenderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        long seed = state.getSeed(pos);
        random.setSeed(seed);
        List parts = model.collectParts(random);
        int size = parts.size();
        Supplier defaultLayer = Suppliers.memoize(() -> ItemBlockRenderTypes.getChunkRenderType((BlockState)state));
        ChunkSectionLayer firstLayer = LayerBakedModel.getBlockRenderLayer((BlockModelPart)parts.getFirst(), (Supplier<ChunkSectionLayer>)defaultLayer);
        if (size == 1) {
            MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(firstLayer)];
            emitter.prepare(resultConsumer);
            poseStack.pushPose();
            blockRenderer.tesselateBlock(level, parts, state, pos, poseStack, (VertexConsumer)emitter, false, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            emitter.end();
        } else {
            ChunkSectionLayer[] renderLayers = new ChunkSectionLayer[size];
            renderLayers[0] = firstLayer;
            boolean simple = true;
            for (int i = 1; i < size; ++i) {
                renderLayers[i] = LayerBakedModel.getBlockRenderLayer((BlockModelPart)parts.get(i), (Supplier<ChunkSectionLayer>)defaultLayer);
                if (!simple || renderLayers[i] == firstLayer) continue;
                simple = false;
            }
            if (simple) {
                MeshEmitter emitter = emitters[CHUNK_LAYERS_INDEX.get(firstLayer)];
                emitter.prepare(resultConsumer);
                poseStack.pushPose();
                blockRenderer.tesselateBlock(level, parts, state, pos, poseStack, (VertexConsumer)emitter, false, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
                emitter.end();
            } else {
                int i;
                boolean[] pending = new boolean[size];
                for (i = 0; i < size; ++i) {
                    int index = CHUNK_LAYERS_INDEX.get(renderLayers[i]);
                    MeshEmitter emitter = emitters[index];
                    if (!pending[index]) {
                        pending[index] = true;
                        emitter.prepare(resultConsumer);
                    }
                    poseStack.pushPose();
                    blockRenderer.tesselateBlock(level, List.of((BlockModelPart)parts.get(i)), state, pos, poseStack, (VertexConsumer)emitter, false, OverlayTexture.NO_OVERLAY);
                    poseStack.popPose();
                }
                for (i = 0; i < size; ++i) {
                    if (!pending[i]) continue;
                    emitters[i].end();
                }
            }
        }
    }

    public static void bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, boolean renderFluids, ResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        RandomSource random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        for (MeshEmitter emitter : emitters) {
            emitter.prepare(resultConsumer);
        }
        BlockRenderDispatcher renderDispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer blockRenderer = renderDispatcher.getModelRenderer();
        ModelBlockRenderer.enableCaching();
        while (posIterator.hasNext()) {
            FluidState fluidState;
            BlockPos pos = posIterator.next();
            BlockState state = level.getBlockState(pos);
            if (renderFluids && !(fluidState = state.getFluidState()).isEmpty()) {
                ChunkSectionLayer renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
                transformingWrapper.prepare((VertexConsumer)emitters[CHUNK_LAYERS_INDEX.get(renderType)].unwrap(true), poseStack);
                poseStack.pushPose();
                poseStack.translate((float)(pos.getX() - (pos.getX() & 0xF)), (float)(pos.getY() - (pos.getY() & 0xF)), (float)(pos.getZ() - (pos.getZ() & 0xF)));
                renderDispatcher.renderLiquid(pos, level, (VertexConsumer)transformingWrapper, state, fluidState);
                poseStack.popPose();
            }
            if (state.getRenderShape() != RenderShape.MODEL) continue;
            long seed = state.getSeed(pos);
            BlockStateModel model = renderDispatcher.getBlockModel(state);
            random.setSeed(seed);
            ChunkSectionLayer renderType = ItemBlockRenderTypes.getChunkRenderType((BlockState)state);
            int layerIndex = CHUNK_LAYERS_INDEX.get(renderType);
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ObjectArrayList parts = new ObjectArrayList();
            BlockStateModel blockStateModel = WrapperBlockStateModel.unwrapCompat(model);
            if (blockStateModel instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)blockStateModel;
                wrapper.addPartsWithInfo(level, pos, state, random, (List<BlockModelPart>)parts);
            } else {
                model.collectParts(random, (List)parts);
            }
            blockRenderer.tesselateBlock(level, (List)parts, state, pos, poseStack, (VertexConsumer)emitters[layerIndex], true, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        ModelBlockRenderer.clearCache();
        transformingWrapper.clear();
        for (MeshEmitter emitter : emitters) {
            emitter.end();
        }
    }

    static {
        for (int layerIndex = 0; layerIndex < CHUNK_LAYER_AMOUNT; ++layerIndex) {
            CHUNK_LAYERS_INDEX.put(CHUNK_LAYERS[layerIndex], layerIndex);
        }
        THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    }

    private static class ThreadLocalObjects {
        public final PoseStack identityPoseStack = new PoseStack();
        public final RandomSource random = RandomSource.createNewThreadLocalInstance();
        public final MeshEmitter[] emitters = new MeshEmitter[CHUNK_LAYER_AMOUNT];
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
            for (int layerIndex = 0; layerIndex < CHUNK_LAYER_AMOUNT; ++layerIndex) {
                ChunkSectionLayer renderType = CHUNK_LAYERS[layerIndex];
                this.emitters[layerIndex] = new MeshEmitter(renderType);
            }
        }
    }

    public static interface ResultConsumer {
        public void accept(ChunkSectionLayer var1, boolean var2, MeshData var3);
    }
}

