/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedItemModelBufferer;
import com.zurrtum.create.client.flywheel.lib.vertex.FullVertexView;
import java.util.function.BiConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ItemMeshEmitter
implements VertexConsumer {
    private final RenderType renderType;
    private final ByteBufferBuilder byteBufferBuilder;
    private @UnknownNullability BufferBuilder bufferBuilder;
    private BakedItemModelBufferer.ResultConsumer resultConsumer;
    private BiConsumer<RenderType, Mesh> meshResultConsumer;
    private boolean currentShade;
    private boolean ended = true;

    ItemMeshEmitter(RenderType renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new ByteBufferBuilder(renderType.bufferSize());
    }

    public void prepare(BakedItemModelBufferer.ResultConsumer resultConsumer, BiConsumer<RenderType, Mesh> meshResultConsumer) {
        this.resultConsumer = resultConsumer;
        this.meshResultConsumer = meshResultConsumer;
        this.ended = false;
    }

    public boolean isEnd() {
        return this.ended;
    }

    public void end() {
        if (this.ended) {
            return;
        }
        if (this.bufferBuilder != null) {
            this.emit();
        }
        this.resultConsumer = null;
        this.meshResultConsumer = null;
        this.ended = true;
    }

    public BufferBuilder unwrap(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (this.bufferBuilder == null) {
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }
        this.currentShade = shade;
    }

    private void prepareForGeometry(BakedQuad quad) {
        this.prepareForGeometry(quad.shade());
    }

    private void emit() {
        MeshData data = this.bufferBuilder.build();
        this.bufferBuilder = null;
        if (data != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, data);
            data.close();
        }
    }

    public void emit(ModelPart part, PoseStack stack, TextureAtlasSprite meshSprite, ItemMeshEmitter glintEmitter, int light, int overlay, int color) {
        stack.pushPose();
        part.translateAndRotate(stack);
        if (!part.isEmpty()) {
            Mesh mesh = this.compile(part, stack, meshSprite, light, overlay, color);
            this.meshResultConsumer.accept(this.renderType, mesh);
            if (glintEmitter != null) {
                glintEmitter.meshResultConsumer.accept(glintEmitter.renderType, mesh);
            }
        }
        for (ModelPart child : part.children.values()) {
            this.emit(child, stack, meshSprite, glintEmitter, light, overlay, color);
        }
        stack.popPose();
    }

    private Mesh compile(ModelPart part, PoseStack stack, TextureAtlasSprite meshSprite, int light, int overlay, int color) {
        int vertexCount = 0;
        for (ModelPart.Cube cuboid : part.cubes) {
            vertexCount += cuboid.polygons.length * 4;
        }
        MemoryBlock memoryBlock = MemoryBlock.mallocTracked((long)vertexCount * 36L);
        FullVertexView meshVertices = new FullVertexView();
        meshVertices.nativeMemoryOwner(memoryBlock);
        meshVertices.ptr(memoryBlock.ptr());
        meshVertices.vertexCount(vertexCount);
        PoseStack.Pose entry = stack.last();
        Matrix4f matrix4f = entry.pose();
        Vector3f vector3f = new Vector3f();
        int index = 0;
        float red = ARGB.redFloat((int)color);
        float green = ARGB.greenFloat((int)color);
        float blue = ARGB.blueFloat((int)color);
        float alpha = ARGB.alphaFloat((int)color);
        boolean hasUV = meshSprite != null;
        for (ModelPart.Cube cuboid : part.cubes) {
            for (ModelPart.Polygon quad : cuboid.polygons) {
                Vector3f normal = entry.transformNormal(quad.normal(), vector3f);
                float x = normal.x();
                float y = normal.y();
                float z = normal.z();
                for (ModelPart.Vertex vertex : quad.vertices()) {
                    float u = vertex.u();
                    float v = vertex.v();
                    if (hasUV) {
                        u = meshSprite.getU(u);
                        v = meshSprite.getV(v);
                    }
                    Vector3f position = matrix4f.transformPosition(vertex.x() / 16.0f, vertex.y() / 16.0f, vertex.z() / 16.0f, vector3f);
                    meshVertices.x(index, position.x());
                    meshVertices.y(index, position.y());
                    meshVertices.z(index, position.z());
                    meshVertices.r(index, red);
                    meshVertices.g(index, green);
                    meshVertices.b(index, blue);
                    meshVertices.a(index, alpha);
                    meshVertices.u(index, u);
                    meshVertices.v(index, v);
                    meshVertices.overlay(index, overlay);
                    meshVertices.light(index, light);
                    meshVertices.normalX(index, x);
                    meshVertices.normalY(index, y);
                    meshVertices.normalZ(index, z);
                    ++index;
                }
            }
        }
        return new SimpleQuadMesh(meshVertices, "source=ItemMeshEmitter");
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setColor(int color) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv1(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv2(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setNormal(float normalX, float normalY, float normalZ) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setLineWidth(float width) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}

