/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.zurrtum.create.client.flywheel.lib.model.baked.VirtualLightEngine;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public abstract class VirtualBlockGetter
implements BlockAndTintGetter {
    protected final VirtualLightEngine lightEngine;

    public VirtualBlockGetter(ToIntFunction<BlockPos> blockLightFunc, ToIntFunction<BlockPos> skyLightFunc) {
        this.lightEngine = new VirtualLightEngine(blockLightFunc, skyLightFunc, (BlockGetter)this);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public float getShade(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        Biome plainsBiome = (Biome)Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.BIOME).getValueOrThrow(Biomes.PLAINS);
        return resolver.getColor(plainsBiome, (double)pos.getX(), (double)pos.getZ());
    }
}

