/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.task;

import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.task.TaskExecutor;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.task.Synchronizer;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public final class Distribute {
    private Distribute() {
    }

    public static <C, T> void tasks(TaskExecutor taskExecutor, C context, Runnable onCompletion, List<T> list, BiConsumer<T, C> action) {
        int size = list.size();
        if (size == 0) {
            onCompletion.run();
            return;
        }
        int sliceSize = Distribute.sliceSize(taskExecutor, size);
        if (size <= sliceSize) {
            for (T t : list) {
                action.accept(t, context);
            }
            onCompletion.run();
        } else if (sliceSize == 1) {
            Synchronizer synchronizer = new Synchronizer(size, onCompletion);
            for (Object t : list) {
                taskExecutor.execute(() -> {
                    action.accept(t, context);
                    synchronizer.decrementAndEventuallyRun();
                });
            }
        } else {
            Synchronizer synchronizer = new Synchronizer(MoreMath.ceilingDiv(size, sliceSize), onCompletion);
            int remaining = size;
            while (remaining > 0) {
                int end = remaining;
                int start = Math.max(remaining -= sliceSize, 0);
                List subList = list.subList(start, end);
                taskExecutor.execute(() -> {
                    for (Object t : subList) {
                        action.accept(t, context);
                    }
                    synchronizer.decrementAndEventuallyRun();
                });
            }
        }
    }

    public static <C, T> void slices(TaskExecutor taskExecutor, C context, Runnable onCompletion, List<T> list, BiConsumer<List<T>, C> action) {
        int size = list.size();
        if (size == 0) {
            onCompletion.run();
            return;
        }
        int sliceSize = Distribute.sliceSize(taskExecutor, size);
        if (size <= sliceSize) {
            action.accept(list, context);
            onCompletion.run();
        } else if (sliceSize == 1) {
            Synchronizer synchronizer = new Synchronizer(size, onCompletion);
            for (Object t : list) {
                taskExecutor.execute(() -> {
                    action.accept(Collections.singletonList(t), context);
                    synchronizer.decrementAndEventuallyRun();
                });
            }
        } else {
            Synchronizer synchronizer = new Synchronizer(MoreMath.ceilingDiv(size, sliceSize), onCompletion);
            int remaining = size;
            while (remaining > 0) {
                int end = remaining;
                int start = Math.max(remaining -= sliceSize, 0);
                List subList = list.subList(start, end);
                taskExecutor.execute(() -> {
                    action.accept(subList, context);
                    synchronizer.decrementAndEventuallyRun();
                });
            }
        }
    }

    public static <C> void plans(TaskExecutor taskExecutor, C context, Runnable onCompletion, List<Plan<C>> plans) {
        int size = plans.size();
        if (size == 0) {
            onCompletion.run();
            return;
        }
        Synchronizer synchronizer = new Synchronizer(size, onCompletion);
        int sliceSize = Distribute.sliceSize(taskExecutor, size, 8);
        if (size <= sliceSize) {
            for (Plan<C> t : plans) {
                t.execute(taskExecutor, context, synchronizer);
            }
        } else if (sliceSize == 1) {
            for (Plan t : plans) {
                taskExecutor.execute(() -> t.execute(taskExecutor, context, synchronizer));
            }
        } else {
            int remaining = size;
            while (remaining > 0) {
                int end = remaining;
                int start = Math.max(remaining -= sliceSize, 0);
                List subList = plans.subList(start, end);
                taskExecutor.execute(() -> {
                    for (Plan t : subList) {
                        t.execute(taskExecutor, context, synchronizer);
                    }
                });
            }
        }
    }

    public static int sliceSize(TaskExecutor taskExecutor, int totalSize) {
        return Distribute.sliceSize(taskExecutor, totalSize, 32);
    }

    public static int sliceSize(TaskExecutor taskExecutor, int totalSize, int denominator) {
        return MoreMath.ceilingDiv(totalSize, taskExecutor.threadCount() * denominator);
    }
}

