/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.transform;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public final class PoseTransformStack
implements TransformStack<PoseTransformStack> {
    private final PoseStack stack;

    @ApiStatus.Internal
    public PoseTransformStack(PoseStack stack) {
        this.stack = stack;
    }

    @Override
    public PoseTransformStack pushPose() {
        this.stack.pushPose();
        return this;
    }

    @Override
    public PoseTransformStack popPose() {
        this.stack.popPose();
        return this;
    }

    @Override
    public PoseTransformStack mulPose(Matrix4fc pose) {
        this.stack.last().pose().mul(pose);
        return this;
    }

    @Override
    public PoseTransformStack mulNormal(Matrix3fc normal) {
        this.stack.last().normal().mul(normal);
        return this;
    }

    @Override
    public PoseTransformStack rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        PoseStack.Pose pose = this.stack.last();
        pose.pose().rotateAround(quaternion, x, y, z);
        pose.normal().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack translate(float x, float y, float z) {
        this.stack.translate(x, y, z);
        return this;
    }

    @Override
    public PoseTransformStack rotate(Quaternionfc quaternion) {
        PoseStack.Pose pose = this.stack.last();
        pose.pose().rotate(quaternion);
        pose.normal().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack scale(float factorX, float factorY, float factorZ) {
        this.stack.scale(factorX, factorY, factorZ);
        return this;
    }

    public PoseStack unwrap() {
        return this.stack;
    }
}

