/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.IdentifierException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public final class ResourceUtil {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.id.invalid"));

    private ResourceUtil() {
    }

    public static Identifier rl(String path) {
        return Identifier.fromNamespaceAndPath((String)"flywheel", (String)path);
    }

    public static Identifier parseFlywheelDefault(String location) {
        String namespace = "flywheel";
        String path = location;
        int i = location.indexOf(58);
        if (i >= 0) {
            path = location.substring(i + 1);
            if (i >= 1) {
                namespace = location.substring(0, i);
            }
        }
        return Identifier.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static Identifier readFlywheelDefault(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && Identifier.isAllowedInIdentifier((char)reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            return ResourceUtil.parseFlywheelDefault(s);
        }
        catch (IdentifierException var4) {
            reader.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static String toDebugFileNameNoExtension(Identifier Identifier2) {
        String stringLoc = Identifier2.toDebugFileName();
        return stringLoc.substring(0, stringLoc.lastIndexOf(46));
    }
}

