/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.EntityVisibilityTester;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.FrustumIntersection;
import org.joml.Vector3f;

public abstract class AbstractEntityVisual<T extends Entity>
extends AbstractVisual
implements EntityVisual<T> {
    protected final T entity;
    protected final EntityVisibilityTester visibilityTester;

    public AbstractEntityVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity.level(), partialTick);
        this.entity = entity;
        this.visibilityTester = new EntityVisibilityTester((Entity)entity, ctx.renderOrigin(), 1.5f);
    }

    public double distanceSquared(double x, double y, double z) {
        return this.entity.distanceToSqr(x, y, z);
    }

    public Vector3f getVisualPosition() {
        Vec3 pos = this.entity.position();
        Vec3i renderOrigin = this.renderOrigin();
        return new Vector3f((float)(pos.x - (double)renderOrigin.getX()), (float)(pos.y - (double)renderOrigin.getY()), (float)(pos.z - (double)renderOrigin.getZ()));
    }

    public Vector3f getVisualPosition(float partialTick) {
        Vec3 pos = this.entity.position();
        Vec3i renderOrigin = this.renderOrigin();
        return new Vector3f((float)(Mth.lerp((double)partialTick, (double)((Entity)this.entity).xOld, (double)pos.x) - (double)renderOrigin.getX()), (float)(Mth.lerp((double)partialTick, (double)((Entity)this.entity).yOld, (double)pos.y) - (double)renderOrigin.getY()), (float)(Mth.lerp((double)partialTick, (double)((Entity)this.entity).zOld, (double)pos.z) - (double)renderOrigin.getZ()));
    }

    public boolean isVisible(FrustumIntersection frustum) {
        return !Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(this.entity).affectedByCulling(this.entity) || this.visibilityTester.check(frustum);
    }

    protected int computePackedLight(float partialTick) {
        BlockPos pos = BlockPos.containing((Position)this.entity.getLightProbePosition(partialTick));
        int blockLight = this.entity.isOnFire() ? 15 : this.level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = this.level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }

    protected void relight(float partialTick, FlatLit ... instances) {
        FlatLit.relight(this.computePackedLight(partialTick), instances);
    }
}

