/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.joml.FrustumIntersection;

public class EntityVisibilityTester {
    private final Entity entity;
    private final Vec3i renderOrigin;
    private final float scale;
    @Nullable
    private AABB lastVisibleAABB;

    public EntityVisibilityTester(Entity entity, Vec3i renderOrigin, float scale) {
        this.entity = entity;
        this.renderOrigin = renderOrigin;
        this.scale = scale;
    }

    public boolean check(FrustumIntersection frustum) {
        boolean visible;
        AABB aabb = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(this.entity).getBoundingBoxForCulling(this.entity);
        boolean bl = visible = this.lastVisibleAABB == null;
        if (!visible) {
            visible = this.adjustAndTestAABB(frustum, aabb);
        }
        if (!visible && this.lastVisibleAABB != aabb) {
            visible = this.adjustAndTestAABB(frustum, this.lastVisibleAABB);
        }
        if (visible) {
            this.lastVisibleAABB = aabb;
        }
        return visible;
    }

    private boolean adjustAndTestAABB(FrustumIntersection frustum, AABB aabb) {
        float x = (float)Mth.lerp((double)0.5, (double)aabb.minX, (double)aabb.maxX) - (float)this.renderOrigin.getX();
        float y = (float)Mth.lerp((double)0.5, (double)aabb.minY, (double)aabb.maxY) - (float)this.renderOrigin.getY();
        float z = (float)Mth.lerp((double)0.5, (double)aabb.minZ, (double)aabb.maxZ) - (float)this.renderOrigin.getZ();
        float maxSize = (float)Math.max(aabb.getXsize(), Math.max(aabb.getYsize(), aabb.getZsize()));
        return frustum.testSphere(x, y, z, maxSize * MoreMath.SQRT_3_OVER_2 * this.scale);
    }
}

