/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visualization;

import com.zurrtum.create.client.flywheel.api.visual.Effect;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class VisualizationHelper {
    private VisualizationHelper() {
    }

    public static void queueAdd(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueAdd(effect);
    }

    public static void queueRemove(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueRemove(effect);
    }

    public static void queueUpdate(BlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return;
        }
        manager.blockEntities().queueUpdate(blockEntity);
    }

    public static void queueUpdate(Entity entity) {
        Level level = entity.level();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return;
        }
        manager.entities().queueUpdate(entity);
    }

    public static void queueUpdate(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueUpdate(effect);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityVisualizer<? super T> getVisualizer(T blockEntity) {
        return VisualizerRegistry.getVisualizer(blockEntity.getType());
    }

    @Nullable
    public static <T extends Entity> EntityVisualizer<? super T> getVisualizer(T entity) {
        return VisualizerRegistry.getVisualizer(entity.getType());
    }

    public static <T extends BlockEntity> boolean canVisualize(T blockEntity) {
        return VisualizationHelper.getVisualizer(blockEntity) != null;
    }

    public static <T extends Entity> boolean canVisualize(T entity) {
        return VisualizationHelper.getVisualizer(entity) != null;
    }

    public static <T extends BlockEntity> boolean skipVanillaRender(T blockEntity) {
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static <T extends Entity> boolean skipVanillaRender(T entity) {
        EntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(entity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(entity);
    }

    public static Iterator<Entity> skipVanillaRender(ClientLevel world, Iterator<Entity> iterator) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            return new EntitySkipIterator(iterator);
        }
        return iterator;
    }

    public static <T extends BlockEntity> boolean tryAddBlockEntity(T blockEntity) {
        Level level = blockEntity.getLevel();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return false;
        }
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        manager.blockEntities().queueAdd(blockEntity);
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static class EntitySkipIterator
    implements Iterator<Entity> {
        private final Iterator<Entity> iterator;
        private Entity next;

        public EntitySkipIterator(Iterator<Entity> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                Entity entity = this.iterator.next();
                if (VisualizationHelper.skipVanillaRender(entity)) continue;
                this.next = entity;
                return true;
            }
            return false;
        }

        @Override
        public Entity next() {
            if (this.hasNext()) {
                Entity entity = this.next;
                this.next = null;
                return entity;
            }
            throw new NoSuchElementException();
        }
    }
}

