/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsScreen;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsInputHandler;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ValueSettingsClient {
    public int interactHeldTicks = -1;
    public BlockPos interactHeldPos = null;
    public BehaviourType<? extends BlockEntityBehaviour<?>> interactHeldBehaviour = null;
    public InteractionHand interactHeldHand = null;
    public Direction interactHeldFace = null;
    public List<MutableComponent> lastHoverTip;
    public int hoverTicks;
    public int hoverWarmup;

    public boolean cancelIfWarmupAlreadyStarted(BlockPos pos) {
        return this.interactHeldTicks != -1 && pos.equals((Object)this.interactHeldPos);
    }

    public void startInteractionWith(BlockPos pos, BehaviourType<? extends BlockEntityBehaviour<?>> behaviourType, InteractionHand hand, Direction side) {
        this.interactHeldTicks = 0;
        this.interactHeldPos = pos;
        this.interactHeldBehaviour = behaviourType;
        this.interactHeldHand = hand;
        this.interactHeldFace = side;
    }

    public void cancelInteraction() {
        this.interactHeldTicks = -1;
    }

    public void tick(Minecraft mc) {
        ValueSettingsBehaviour valueSettingBehaviour;
        BlockHitResult blockHitResult;
        if (this.hoverWarmup > 0) {
            --this.hoverWarmup;
        }
        if (this.hoverTicks > 0) {
            --this.hoverTicks;
        }
        if (this.interactHeldTicks == -1) {
            return;
        }
        LocalPlayer player = mc.player;
        if (!ValueSettingsInputHandler.canInteract((Player)player) || player.getMainHandItem().is((Item)AllItems.CLIPBOARD)) {
            this.cancelInteraction();
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult) || !(blockHitResult = (BlockHitResult)hitResult).getBlockPos().equals((Object)this.interactHeldPos)) {
            this.cancelInteraction();
            return;
        }
        BlockEntityBehaviour<?> behaviour = BlockEntityBehaviour.get((BlockGetter)mc.level, this.interactHeldPos, this.interactHeldBehaviour);
        if (!(behaviour instanceof ValueSettingsBehaviour) || (valueSettingBehaviour = (ValueSettingsBehaviour)((Object)behaviour)).bypassesInput(player.getMainHandItem()) || !valueSettingBehaviour.testHit(blockHitResult.getLocation())) {
            this.cancelInteraction();
            return;
        }
        if (!mc.options.keyUse.isDown()) {
            player.connection.send((Packet)new ValueSettingsPacket(this.interactHeldPos, 0, 0, this.interactHeldHand, blockHitResult, this.interactHeldFace, false, valueSettingBehaviour.netId()));
            valueSettingBehaviour.onShortInteract((Player)player, this.interactHeldHand, this.interactHeldFace, blockHitResult);
            this.cancelInteraction();
            return;
        }
        if (this.interactHeldTicks > 3) {
            player.swinging = false;
        }
        if (this.interactHeldTicks++ < 5) {
            return;
        }
        ScreenOpener.open(new ValueSettingsScreen(this.interactHeldPos, valueSettingBehaviour.createBoard((Player)player, blockHitResult), valueSettingBehaviour.getValueSettings(), valueSettingBehaviour::newSettingHovered, valueSettingBehaviour.netId()));
        this.interactHeldTicks = -1;
    }

    public void showHoverTip(Minecraft mc, List<MutableComponent> tip) {
        if (mc.screen != null) {
            return;
        }
        if (this.hoverWarmup < 6) {
            this.hoverWarmup += 2;
            return;
        }
        ++this.hoverWarmup;
        this.hoverTicks = this.hoverTicks == 0 ? 11 : Math.max(this.hoverTicks, 6);
        this.lastHoverTip = tip;
    }

    public void render(Minecraft mc, GuiGraphics guiGraphics) {
        if (!ValueSettingsInputHandler.canInteract((Player)mc.player)) {
            return;
        }
        if (this.hoverTicks == 0 || this.lastHoverTip == null) {
            return;
        }
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight() - 75 - this.lastHoverTip.size() * 12;
        float alpha = this.hoverTicks > 5 ? (float)(11 - this.hoverTicks) / 5.0f : Math.min(1.0f, (float)this.hoverTicks / 5.0f);
        Color color = new Color(0xFFFFFF);
        Color titleColor = new Color(16505981);
        color.setAlpha(alpha);
        titleColor.setAlpha(alpha);
        for (int i = 0; i < this.lastHoverTip.size(); ++i) {
            MutableComponent mutableComponent = this.lastHoverTip.get(i);
            guiGraphics.drawString(mc.font, (Component)mutableComponent, x - mc.font.width((FormattedText)mutableComponent) / 2, y, (i == 0 ? titleColor : color).getRGB(), true);
            y += 12;
        }
    }
}

