/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class ValueSettingsInputHandler {
    public static InteractionResult onBlockActivated(Level world, LocalPlayer player, InteractionHand hand, BlockHitResult ray) {
        if (!ValueSettingsInputHandler.canInteract((Player)player)) {
            return null;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)AllItems.CLIPBOARD)) {
            return null;
        }
        BlockPos pos = ray.getBlockPos();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return null;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        if (Create.VALUE_SETTINGS_HANDLER.cancelIfWarmupAlreadyStarted(pos)) {
            return InteractionResult.FAIL;
        }
        if (sbe instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)sbe;
            for (FilteringBehaviour<?> behaviour : FactoryPanelBehaviour.allBehaviours(fpbe)) {
                InteractionResult result = ValueSettingsInputHandler.handleInteraction(behaviour, behaviour.getType(), player, hand, ray, stack, pos, sbe);
                if (result == null) continue;
                return result;
            }
        } else {
            InteractionResult result;
            ScrollValueBehaviour<?, ?> scrollValueBehaviour = sbe.getBehaviour(ScrollValueBehaviour.TYPE);
            if (scrollValueBehaviour != null && (result = ValueSettingsInputHandler.handleInteraction(scrollValueBehaviour, ScrollValueBehaviour.TYPE, player, hand, ray, stack, pos, sbe)) != null) {
                return result;
            }
            FilteringBehaviour<Object> filteringBehaviour = sbe.getBehaviour(FilteringBehaviour.TYPE);
            if (filteringBehaviour instanceof SidedFilteringBehaviour) {
                SidedFilteringBehaviour sidedBehaviour = (SidedFilteringBehaviour)filteringBehaviour;
                filteringBehaviour = sidedBehaviour.get(ray.getDirection());
            }
            if (filteringBehaviour != null) {
                return ValueSettingsInputHandler.handleInteraction(filteringBehaviour, FilteringBehaviour.TYPE, player, hand, ray, stack, pos, sbe);
            }
        }
        return null;
    }

    private static InteractionResult handleInteraction(BlockEntityBehaviour<?> behaviour, BehaviourType<? extends BlockEntityBehaviour<?>> type, LocalPlayer player, InteractionHand hand, BlockHitResult ray, ItemStack stack, BlockPos pos, SmartBlockEntity sbe) {
        ValueSettingsBehaviour valueSettingsBehaviour = (ValueSettingsBehaviour)((Object)behaviour);
        if (valueSettingsBehaviour.bypassesInput(stack)) {
            return null;
        }
        if (!valueSettingsBehaviour.mayInteract((Player)player)) {
            return null;
        }
        if (!valueSettingsBehaviour.isActive()) {
            return null;
        }
        if (valueSettingsBehaviour.onlyVisibleWithWrench() && !player.getItemInHand(hand).getItemHolder().is(AllItemTags.TOOLS_WRENCH)) {
            return null;
        }
        ValueBoxTransform valueBoxTransform = valueSettingsBehaviour.getSlotPositioning();
        if (valueBoxTransform instanceof ValueBoxTransform.Sided) {
            ValueBoxTransform.Sided sidedSlot = (ValueBoxTransform.Sided)valueBoxTransform;
            if (!sidedSlot.isSideActive(sbe.getBlockState(), ray.getDirection())) {
                return null;
            }
            sidedSlot.fromSide(ray.getDirection());
        }
        boolean fakePlayer = FakePlayerHandler.has((Entity)player);
        if (!valueSettingsBehaviour.testHit(ray.getLocation())) {
            return null;
        }
        if (!valueSettingsBehaviour.acceptsValueSettings() || fakePlayer) {
            valueSettingsBehaviour.onShortInteract((Player)player, hand, ray.getDirection(), ray);
            player.connection.send((Packet)new ValueSettingsPacket(pos, 0, 0, hand, ray, ray.getDirection(), false, valueSettingsBehaviour.netId()));
            return InteractionResult.SUCCESS;
        }
        Create.VALUE_SETTINGS_HANDLER.startInteractionWith(pos, type, hand, ray.getDirection());
        return InteractionResult.SUCCESS;
    }

    public static boolean canInteract(Player player) {
        return player != null && !player.isSpectator() && !player.isShiftKeyDown() && player.mayBuild();
    }
}

