/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.animation;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CuckooClockAnimationBehaviour
extends AnimationBehaviour<CuckooClockBlockEntity> {
    public LerpedFloat hourHand = LerpedFloat.angular();
    public LerpedFloat minuteHand = LerpedFloat.angular();

    public CuckooClockAnimationBehaviour(CuckooClockBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAnimation() {
        block13: {
            CuckooClockBlockEntity.Animation animationType;
            Level world;
            block11: {
                block12: {
                    if (((CuckooClockBlockEntity)this.blockEntity).getSpeed() == 0.0f) {
                        return;
                    }
                    world = ((CuckooClockBlockEntity)this.blockEntity).getLevel();
                    int dayTime = (int)(world.getDayTime() % 24000L);
                    int hours = (dayTime / 1000 + 6) % 24;
                    int minutes = dayTime % 1000 * 60 / 1000;
                    this.moveHands(hours, minutes);
                    animationType = ((CuckooClockBlockEntity)this.blockEntity).animationType;
                    if (animationType != CuckooClockBlockEntity.Animation.NONE) break block11;
                    if (AnimationTickHolder.getTicks() % 32 != 0) break block12;
                    this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), 0.0625f, 2.0f);
                    break block13;
                }
                if (AnimationTickHolder.getTicks() % 16 != 0) break block13;
                this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), 0.0625f, 1.5f);
                break block13;
            }
            boolean isSurprise = animationType == CuckooClockBlockEntity.Animation.SURPRISE;
            float value = ((CuckooClockBlockEntity)this.blockEntity).getAndIncrementProgress();
            if (value > 100.0f) {
                animationType = null;
            }
            if (value == 1.0f) {
                this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 2.0f, 0.5f);
            }
            if (value == 21.0f) {
                this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 2.0f, 0.793701f);
            }
            if (value > 30.0f && isSurprise) {
                Vec3 pos = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)((CuckooClockBlockEntity)this.blockEntity).getBlockPos()), world.random, 0.5f);
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
            if (value == 40.0f && isSurprise) {
                this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.0f);
            }
            int step = isSurprise ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                if (value == (float)(phase - step / 3)) {
                    this.playSound(SoundEvents.CHEST_OPEN, 0.0625f, 2.0f);
                }
                if (value == (float)phase) {
                    if (animationType == CuckooClockBlockEntity.Animation.PIG) {
                        this.playSound(SoundEvents.PIG_AMBIENT, 0.25f, 1.0f);
                    } else {
                        this.playSound(SoundEvents.CREEPER_HURT, 0.25f, 3.0f);
                    }
                }
                if (value != (float)(phase + step / 3)) continue;
                this.playSound(SoundEvents.CHEST_CLOSE, 0.0625f, 2.0f);
            }
        }
    }

    private void moveHands(int hours, int minutes) {
        float hourTarget = 30 * (hours % 12);
        float minuteTarget = 6 * minutes;
        this.hourHand.chase(hourTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.minuteHand.chase(minuteTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.hourHand.tickChaser();
        this.minuteHand.tickChaser();
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        Vec3 vec = VecHelper.getCenterOf((Vec3i)((CuckooClockBlockEntity)this.blockEntity).getBlockPos());
        ((CuckooClockBlockEntity)this.blockEntity).getLevel().playLocalSound(vec.x, vec.y, vec.z, sound, SoundSource.BLOCKS, volume, pitch, false);
    }
}

