/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.kinetics.motor.MotorValueBox;
import com.zurrtum.create.client.content.kinetics.speedController.ControllerValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlockEntity;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class KineticScrollValueBehaviour
extends ScrollValueBehaviour<SmartBlockEntity, ServerScrollValueBehaviour> {
    public KineticScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
        this.withFormatter(v -> String.valueOf(Math.abs(v)));
    }

    public static KineticScrollValueBehaviour motor(CreativeMotorBlockEntity blockEntity) {
        return new KineticScrollValueBehaviour((Component)CreateLang.translateDirect("kinetics.creative_motor.rotation_speed", new Object[0]), blockEntity, (ValueBoxTransform)new MotorValueBox());
    }

    public static KineticScrollValueBehaviour controller(SpeedControllerBlockEntity blockEntity) {
        return new KineticScrollValueBehaviour((Component)CreateLang.translateDirect("kinetics.speed_controller.rotation_speed", new Object[0]), blockEntity, (ValueBoxTransform)new ControllerValueBoxTransform());
    }

    @Override
    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Component.literal((String)"\u27f3").withStyle(ChatFormatting.BOLD), (Object)Component.literal((String)"\u27f2").withStyle(ChatFormatting.BOLD));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 256, 32, (List<Component>)rows, formatter);
    }

    public MutableComponent formatSettings(ValueSettings settings) {
        return CreateLang.number(Math.max(1, Math.abs(settings.value()))).add(CreateLang.text(settings.row() == 0 ? "\u27f3" : "\u27f2").style(ChatFormatting.BOLD)).component();
    }
}

