/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.contraptions.DirectionalExtenderScrollOptionSlot;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class ScrollOptionBehaviour<T extends Enum<T>>
extends ScrollValueBehaviour<SmartBlockEntity, ServerScrollOptionBehaviour<T>> {
    private final INamedIconOptions[] icons;
    private final Function<T, INamedIconOptions> iconGetter;

    public <E extends Enum<E>> ScrollOptionBehaviour(Class<E> enum_, Function<T, INamedIconOptions> getter, Component label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
        this.icons = (INamedIconOptions[])enum_.getEnumConstants();
        this.iconGetter = getter;
    }

    public INamedIconOptions getIconForSelected() {
        return this.iconGetter.apply(((ServerScrollOptionBehaviour)this.behaviour).get());
    }

    @Override
    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        return new ValueSettingsBoard(this.label, ((ServerScrollOptionBehaviour)this.behaviour).getMax(), 1, (List<Component>)ImmutableList.of((Object)Component.literal((String)"Select")), new ValueSettingsFormatter.ScrollOptionSettingsFormatter(this.icons));
    }

    public static ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            Direction.Axis axis = d.getAxis();
            Direction.Axis bearingAxis = ((Direction)state.getValue((Property)BearingBlock.FACING)).getAxis();
            return bearingAxis != axis;
        });
    }
}

