/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BasinTooltipBehaviour
extends TooltipBehaviour<BasinBlockEntity>
implements IHaveGoggleInformation {
    public BasinTooltipBehaviour(BasinBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BasinBlockEntity.BasinFluidHandler fluidCapability;
        CreateLang.translate("gui.goggles.basin_contents", new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        BasinInventory itemCapability = ((BasinBlockEntity)this.blockEntity).itemCapability;
        if (itemCapability != null) {
            int size = itemCapability.getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack stackInSlot = itemCapability.getItem(i);
                if (stackInSlot.isEmpty()) continue;
                CreateLang.text("").add(stackInSlot.getItemName().copy().withStyle(ChatFormatting.GRAY)).add(CreateLang.text(" x" + stackInSlot.getCount()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
                isEmpty = false;
            }
        }
        if ((fluidCapability = ((BasinBlockEntity)this.blockEntity).fluidCapability) != null) {
            LangBuilder mb = CreateLang.translate("generic.unit.millibuckets", new Object[0]);
            int size = fluidCapability.size();
            for (int i = 0; i < size; ++i) {
                FluidStack fluidStack = fluidCapability.getStack(i);
                if (fluidStack.isEmpty()) continue;
                CreateLang.text("").add(CreateLang.fluidName(fluidStack).add(CreateLang.text(" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount() / 81.0).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
                isEmpty = false;
            }
        }
        if (isEmpty) {
            tooltip.removeFirst();
        }
        return true;
    }
}

