/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ChuteTooltipBehaviour
extends TooltipBehaviour<ChuteBlockEntity>
implements IHaveGoggleInformation {
    public ChuteTooltipBehaviour(ChuteBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean downward = ((ChuteBlockEntity)this.blockEntity).getItemMotion() < 0.0f;
        CreateLang.translate("tooltip.chute.header", new Object[0]).forGoggles(tooltip);
        float pull = ((ChuteBlockEntity)this.blockEntity).pull;
        float push = ((ChuteBlockEntity)this.blockEntity).push;
        if (pull == 0.0f && push == 0.0f) {
            CreateLang.translate("tooltip.chute.no_fans_attached", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        if (pull != 0.0f) {
            CreateLang.translate("tooltip.chute.fans_" + (pull > 0.0f ? "pull_up" : "push_down"), new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        if (push != 0.0f) {
            CreateLang.translate("tooltip.chute.fans_" + (push > 0.0f ? "push_up" : "pull_down"), new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        }
        CreateLang.text("-> ").add(CreateLang.translate("tooltip.chute.items_move_" + (downward ? "down" : "up"), new Object[0])).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        ItemStack item = ((ChuteBlockEntity)this.blockEntity).getItem();
        if (!item.isEmpty()) {
            CreateLang.translate("tooltip.chute.contains", item.getHoverName().getString(), item.getCount()).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        return true;
    }
}

