/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.KineticTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class DeployerTooltipBehaviour
extends KineticTooltipBehaviour<DeployerBlockEntity> {
    public DeployerTooltipBehaviour(DeployerBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (((DeployerBlockEntity)this.blockEntity).getSpeed() == 0.0f) {
            return false;
        }
        if (((DeployerBlockEntity)this.blockEntity).overflowItems.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.full_deployer", new Object[0]);
        return true;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate("tooltip.deployer.header", new Object[0]).forGoggles(tooltip);
        CreateLang.translate("tooltip.deployer." + (((DeployerBlockEntity)this.blockEntity).mode == DeployerBlockEntity.Mode.USE ? "using" : "punching"), new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        ItemStack heldItem = ((DeployerBlockEntity)this.blockEntity).heldItem;
        if (!heldItem.isEmpty()) {
            CreateLang.translate("tooltip.deployer.contains", heldItem.getHoverName(), heldItem.getCount()).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        float stressAtBase = ((DeployerBlockEntity)this.blockEntity).calculateStressApplied();
        if (IRotate.StressImpact.isEnabled() && !Mth.equal((float)stressAtBase, (float)0.0f)) {
            tooltip.add(CommonComponents.EMPTY);
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        return true;
    }
}

