/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.tank.BoilerData;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;

public class FluidTankTooltipBehaviour
extends TooltipBehaviour<FluidTankBlockEntity>
implements IHaveGoggleInformation {
    public FluidTankTooltipBehaviour(FluidTankBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FluidTankBlockEntity controllerBE = ((FluidTankBlockEntity)this.blockEntity).getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        if (this.addBoilerDataTooltip(controllerBE.boiler, tooltip, controllerBE.getTotalTankSize())) {
            return true;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, FluidHelper.getFluidInventory(((FluidTankBlockEntity)this.blockEntity).getLevel(), controllerBE.getBlockPos(), null, this.blockEntity, null));
    }

    public boolean addBoilerDataTooltip(BoilerData data, List<Component> tooltip, int boilerSize) {
        if (!data.isActive()) {
            return false;
        }
        data.calcMinMaxForSize(boilerSize);
        CreateLang.translate("boiler.status", data.getHeatLevelTextComponent().withStyle(ChatFormatting.GREEN)).forGoggles(tooltip);
        CreateLang.builder().add(data.getSizeComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        CreateLang.builder().add(data.getWaterComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        CreateLang.builder().add(data.getHeatComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        if (data.attachedEngines == 0) {
            return true;
        }
        int boilerLevel = Math.min(data.activeHeat, Math.min(data.maxHeatForWater, data.maxHeatForSize));
        double totalSU = (double)(data.getEngineEfficiency(boilerSize) * 16.0f * (float)Math.max(boilerLevel, data.attachedEngines)) * BlockStressValues.getCapacity((Block)AllBlocks.STEAM_ENGINE);
        tooltip.add(CommonComponents.EMPTY);
        if (data.attachedEngines > 0 && data.maxHeatForSize > 0 && data.maxHeatForWater == 0 && (data.passiveHeat ? 1 : data.activeHeat) > 0) {
            CreateLang.translate("boiler.water_input_rate", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number(data.waterSupply / 81.0f).style(ChatFormatting.BLUE).add(CreateLang.translate("generic.unit.millibuckets", new Object[0])).add(CreateLang.text(" / ").style(ChatFormatting.GRAY)).add(CreateLang.translate("boiler.per_tick", CreateLang.number(10.0).add(CreateLang.translate("generic.unit.millibuckets", new Object[0]))).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            return true;
        }
        CreateLang.translate("tooltip.capacityProvided", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number(totalSU).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add((data.attachedEngines == 1 ? CreateLang.translate("boiler.via_one_engine", new Object[0]) : CreateLang.translate("boiler.via_engines", data.attachedEngines)).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }
}

