/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class KineticTooltipBehaviour<T extends KineticBlockEntity>
extends TooltipBehaviour<T>
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    public KineticTooltipBehaviour(T be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean bl = notFastEnough = !((KineticBlockEntity)this.blockEntity).isSpeedRequirementFulfilled() && ((KineticBlockEntity)this.blockEntity).getSpeed() != 0.0f;
        if (((KineticBlockEntity)this.blockEntity).isOverStressed() && ((Boolean)AllConfigs.client().enableOverstressedTooltip.get()).booleanValue()) {
            CreateLang.translate("gui.stressometer.overstressed", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = CreateLang.translateDirect("gui.contraptions.network_overstressed", new Object[0]);
            List<Component> cutString = TooltipHelper.cutTextComponent((Component)hint, FontHelper.Palette.GRAY_AND_WHITE);
            for (Component component : cutString) {
                CreateLang.builder().add(component.copy()).forGoggles(tooltip);
            }
            return true;
        }
        if (notFastEnough) {
            CreateLang.translate("tooltip.speedRequirement", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = CreateLang.translateDirect("gui.contraptions.not_fast_enough", I18n.get((String)((KineticBlockEntity)this.blockEntity).getBlockState().getBlock().getDescriptionId(), (Object[])new Object[0]));
            List<Component> cutString = TooltipHelper.cutTextComponent((Component)hint, FontHelper.Palette.GRAY_AND_WHITE);
            for (Component component : cutString) {
                CreateLang.builder().add(component.copy()).forGoggles(tooltip);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        float stressAtBase = ((KineticBlockEntity)this.blockEntity).calculateStressApplied();
        if (Mth.equal((float)stressAtBase, (float)0.0f)) {
            return false;
        }
        CreateLang.translate("gui.goggles.kinetic_stats", new Object[0]).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, stressAtBase);
        return true;
    }

    protected void addStressImpactStats(List<Component> tooltip, float stressAtBase) {
        CreateLang.translate("tooltip.stressImpact", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = stressAtBase * Math.abs(((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed());
        CreateLang.number(stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate("gui.goggles.at_current_speed", new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }
}

