/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class StockTickerTooltipBehaviour
extends TooltipBehaviour<StockTickerBlockEntity>
implements IHaveHoveringInformation {
    public StockTickerTooltipBehaviour(StockTickerBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        StockTickerBlockEntity.StockTickerInventory receivedPayments = ((StockTickerBlockEntity)this.blockEntity).receivedPayments;
        if (receivedPayments.isEmpty()) {
            return false;
        }
        if (!((StockTickerBlockEntity)this.blockEntity).behaviour.mayAdministrate((Player)Minecraft.getInstance().player)) {
            return false;
        }
        CreateLang.translate("stock_ticker.contains_payments", new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        InventorySummary summary = new InventorySummary();
        int size = receivedPayments.getContainerSize();
        for (int i = 0; i < size; ++i) {
            summary.add(receivedPayments.getItem(i));
        }
        for (BigItemStack entry : summary.getStacksByCount()) {
            CreateLang.builder().text(entry.stack.getHoverName().getString() + " x" + entry.count).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        CreateLang.translate("stock_ticker.click_to_retrieve", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        return true;
    }
}

