/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.GaugeTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.GaugeObservedPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;

public class StressGaugeTooltipBehaviour
extends GaugeTooltipBehaviour<StressGaugeBlockEntity> {
    public StressGaugeTooltipBehaviour(StressGaugeBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = ((StressGaugeBlockEntity)this.blockEntity).getNetworkCapacity();
        float networkStress = ((StressGaugeBlockEntity)this.blockEntity).getNetworkStress();
        double stressFraction = (double)networkStress / (capacity == 0.0 ? 1.0 : capacity);
        CreateLang.translate("gui.stressometer.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (((StressGaugeBlockEntity)this.blockEntity).getTheoreticalSpeed() == 0.0f) {
            CreateLang.text(TooltipHelper.makeProgressBar(3, 0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            StressGaugeTooltipBehaviour.getFormattedStressText(stressFraction).forGoggles(tooltip);
            CreateLang.translate("gui.stressometer.capacity", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            double remainingCapacity = capacity - (double)networkStress;
            LangBuilder su = CreateLang.translate("generic.unit.stress", new Object[0]);
            LangBuilder stressTip = CreateLang.number(remainingCapacity).add(su).style(IRotate.StressImpact.of(stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(CreateLang.number(capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        BlockPos pos = ((StressGaugeBlockEntity)this.blockEntity).getBlockPos();
        if (!pos.equals((Object)StressGaugeBlockEntity.lastSent)) {
            StressGaugeBlockEntity.lastSent = pos;
            Minecraft.getInstance().player.connection.send((Packet)new GaugeObservedPacket(StressGaugeBlockEntity.lastSent));
        }
        return true;
    }

    public static LangBuilder getFormattedStressText(double stressPercent) {
        IRotate.StressImpact stressLevel = IRotate.StressImpact.of(stressPercent);
        return CreateLang.text(TooltipHelper.makeProgressBar(3, Math.min(stressLevel.ordinal() + 1, 3))).translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]).text(String.format(" (%s%%) ", (int)(stressPercent * 100.0))).style(stressLevel.getRelativeColor());
    }
}

