/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredOverlayBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T, ColoredOverlayRenderState> {
    public ColoredOverlayBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public ColoredOverlayRenderState createRenderState() {
        return new ColoredOverlayRenderState();
    }

    public void extractRenderState(T be, ColoredOverlayRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase(be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        state.model = this.getOverlayBuffer(be, state);
        state.color = this.getColor(be, tickProgress);
    }

    public void submit(ColoredOverlayRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    protected abstract int getColor(T var1, float var2);

    protected abstract SuperByteBuffer getOverlayBuffer(T var1, ColoredOverlayRenderState var2);

    public static class ColoredOverlayRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public int color;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.color(this.color).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

