/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.redstone.link.LinkRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SmartBlockEntityRenderer<T extends SmartBlockEntity, S extends SmartRenderState>
implements BlockEntityRenderer<T, S> {
    protected final ItemModelResolver itemModelManager;

    public SmartBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public S createRenderState() {
        return (S)((Object)new SmartRenderState());
    }

    public void extractRenderState(T be, S state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase(be, state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        if (be.isRemoved()) {
            return;
        }
        double distance = ((SmartBlockEntity)be).isVirtual() ? -1.0 : cameraPos.distanceToSqr(VecHelper.getCenterOf((Vec3i)((SmartRenderState)((Object)state)).blockPos));
        ((SmartRenderState)((Object)state)).filter = FilteringRenderer.getFilterRenderState(be, ((SmartRenderState)((Object)state)).blockState, this.itemModelManager, distance);
        ((SmartRenderState)((Object)state)).link = LinkRenderer.getLinkRenderState(be, this.itemModelManager, distance);
    }

    public void submit(S state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (((SmartRenderState)((Object)state)).filter != null) {
            ((SmartRenderState)((Object)state)).filter.render(((SmartRenderState)((Object)state)).blockState, queue, matrices, ((SmartRenderState)((Object)state)).lightCoords);
        }
        if (((SmartRenderState)((Object)state)).link != null) {
            ((SmartRenderState)((Object)state)).link.render(((SmartRenderState)((Object)state)).blockState, queue, matrices, ((SmartRenderState)((Object)state)).lightCoords);
        }
    }

    public static NameplateRenderState getNameplateRenderState(SmartBlockEntity blockEntity, BlockPos pos, Vec3 cameraPos, Component tag, float yOffset, int light) {
        BlockHitResult bhr;
        if (blockEntity.isVirtual()) {
            return null;
        }
        double distance = cameraPos.distanceToSqr(Vec3.atCenterOf((Vec3i)pos));
        if (distance > 4096.0) {
            return null;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult) || (bhr = (BlockHitResult)hitResult).getType() == HitResult.Type.MISS || !bhr.getBlockPos().equals((Object)pos)) {
            return null;
        }
        Vec3 labelPos = new Vec3(0.5, (double)yOffset - 0.25, 0.5);
        return new NameplateRenderState(labelPos, tag, light, distance);
    }

    public static class SmartRenderState
    extends BlockEntityRenderState {
        public FilteringRenderer.FilterRenderState filter;
        public LinkRenderer.LinkRenderState link;
    }

    public record NameplateRenderState(Vec3 pos, Component label, int light, double distance) {
        public void render(PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
            queue.submitNameTag(matrices, this.pos, 0, this.label, true, this.light, this.distance, cameraState);
        }
    }
}

