/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.entity.behaviour;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CarriageParticleBehaviour
extends EntityBehaviour<CarriageContraptionEntity> {
    public static final BehaviourType<CarriageParticleBehaviour> TYPE = new BehaviourType();
    boolean arrived;
    int depressurise;
    double prevMotion;
    LerpedFloat brakes;

    public CarriageParticleBehaviour(CarriageContraptionEntity entity) {
        super(entity);
        this.entity = entity;
        this.arrived = true;
        this.depressurise = 0;
        this.prevMotion = 0.0;
        this.brakes = LerpedFloat.linear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public void tick() {
        boolean stopped;
        Contraption contraption = ((CarriageContraptionEntity)this.entity).getContraption();
        if (contraption == null) {
            return;
        }
        if (!(contraption instanceof CarriageContraption)) {
            return;
        }
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (carriage == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Entity camEntity = mc.getCameraEntity();
        if (camEntity == null) {
            return;
        }
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(((CarriageContraptionEntity)this.entity).level());
        if (!dce.pointsInitialised) {
            return;
        }
        Vec3 leadingAnchor = dce.leadingAnchor();
        if (leadingAnchor == null || !leadingAnchor.closerThan((Position)camEntity.position(), 64.0)) {
            return;
        }
        RandomSource r = ((CarriageContraptionEntity)this.entity).level().random;
        Vec3 contraptionMotion = ((CarriageContraptionEntity)this.entity).position().subtract(((CarriageContraptionEntity)this.entity).getPrevPositionVec());
        double length = contraptionMotion.length();
        if (this.arrived && length > (double)0.01f) {
            this.arrived = false;
        }
        this.arrived |= ((CarriageContraptionEntity)this.entity).isStalled();
        boolean bl = stopped = length < (double)0.002f;
        if (stopped) {
            if (!this.arrived) {
                this.arrived = true;
                this.depressurise = (int)(20.0f * ((CarriageContraptionEntity)this.entity).getCarriage().train.accumulatedSteamRelease / 10.0f);
            }
        } else {
            this.depressurise = 0;
        }
        if (this.depressurise > 0) {
            --this.depressurise;
        }
        this.brakes.chase(this.prevMotion > length + length / 512.0 ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp(0.625));
        this.brakes.tickChaser();
        this.prevMotion = length;
        Level level = ((CarriageContraptionEntity)this.entity).level();
        Vec3 position = ((CarriageContraptionEntity)this.entity).getPosition(0.0f);
        float viewYRot = ((CarriageContraptionEntity)this.entity).getViewYRot(0.0f);
        float viewXRot = ((CarriageContraptionEntity)this.entity).getViewXRot(0.0f);
        int bogeySpacing = ((CarriageContraptionEntity)this.entity).getCarriage().bogeySpacing;
        for (CarriageBogey bogey : ((CarriageContraptionEntity)this.entity).getCarriage().bogeys) {
            float cutoff;
            if (bogey == null) continue;
            boolean spark = this.depressurise == 0 || this.depressurise > 10;
            float f = cutoff = length < 0.125 ? 0.0f : 0.125f;
            if (length > 0.1666666716337204) {
                cutoff = Math.max(cutoff, this.brakes.getValue() * 1.15f);
            }
            for (int j : Iterate.positiveAndNegative) {
                if (r.nextFloat() > cutoff && (spark || r.nextInt(4) == 0)) continue;
                for (int i : Iterate.positiveAndNegative) {
                    if (r.nextFloat() > cutoff && (spark || r.nextInt(4) == 0)) continue;
                    Vec3 v = Vec3.ZERO.add((double)j * 1.15, spark ? (double)-0.6f : 0.32, (double)i);
                    Vec3 m = Vec3.ZERO.add((double)j * (spark ? 0.5 : 0.25), spark ? 0.49 : -0.29, 0.0);
                    m = VecHelper.rotate(m, bogey.pitch.getValue(0.0f), Direction.Axis.X);
                    m = VecHelper.rotate(m, bogey.yaw.getValue(0.0f), Direction.Axis.Y);
                    v = VecHelper.rotate(v, bogey.pitch.getValue(0.0f), Direction.Axis.X);
                    v = VecHelper.rotate(v, bogey.yaw.getValue(0.0f), Direction.Axis.Y);
                    v = VecHelper.rotate(v, -viewYRot - 90.0f, Direction.Axis.Y);
                    v = VecHelper.rotate(v, viewXRot, Direction.Axis.X);
                    v = VecHelper.rotate(v, -180.0, Direction.Axis.Y);
                    v = v.add(0.0, 0.0, bogey.isLeading ? 0.0 : (double)(-bogeySpacing));
                    v = VecHelper.rotate(v, 180.0, Direction.Axis.Y);
                    v = VecHelper.rotate(v, -viewXRot, Direction.Axis.X);
                    v = VecHelper.rotate(v, viewYRot + 90.0f, Direction.Axis.Y);
                    v = v.add(position);
                    m = m.add(contraptionMotion.scale(0.75));
                    level.addParticle(spark ? bogey.getStyle().contactParticle : bogey.getStyle().smokeParticle, v.x, v.y, v.z, m.x, m.y, m.z);
                }
            }
        }
    }
}

