/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.render.BlazeBurnerRenderState;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Direction;
import org.joml.Quaternionfc;

public class BlazeBurnerElementRenderer
extends PictureInPictureRenderer<BlazeBurnerRenderState> {
    public BlazeBurnerElementRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(BlazeBurnerRenderState state, PoseStack matrices) {
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-22.5f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        matrices.scale(1.0f, -1.0f, 1.0f);
        float horizontalAngle = AngleHelper.rad(270.0);
        boolean canDrawFlame = state.heatLevel().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        PartialModel drawHat = AllPartialModels.LOGISTICS_HAT;
        VertexConsumer cutout = this.bufferSource.getBuffer(RenderTypes.cutoutMovingBlock());
        ((SuperByteBuffer)CachedBuffers.partial(AllPartialModels.BLAZE_CAGE, state.block()).rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).light(0xF000F0).renderInto(matrices.last(), cutout);
        FeatureRenderDispatcher renderDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
        SubmitNodeStorage queue = renderDispatcher.getSubmitNodeStorage();
        BlazeBurnerRenderer.getBlazeBurnerRenderData(state.world(), state.block(), state.heatLevel(), state.animation(), horizontalAngle, canDrawFlame, state.drawGoggles(), drawHat, state.hash()).render(matrices, (SubmitNodeCollector)queue);
        renderDispatcher.renderAllFeatures();
    }

    protected float getTranslateY(int height, int windowScaleFactor) {
        return (float)height / 1.6f;
    }

    protected String getTextureLabel() {
        return "Blaze Burner";
    }

    public Class<BlazeBurnerRenderState> getRenderStateClass() {
        return BlazeBurnerRenderState.class;
    }
}

