/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.CrafterRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class CrafterRenderer
extends PictureInPictureRenderer<CrafterRenderState> {
    public CrafterRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(CrafterRenderState state, PoseStack matrices) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-22.5f));
        matrices.translate(-0.5f, -0.16f, -0.5f);
        matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        BlockState blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        matrices.pushPose();
        List parts = List.of(AllPartialModels.SHAFTLESS_COGWHEEL.get());
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(CrafterRenderer.getCurrentAngle()));
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        blockState = AllBlocks.MECHANICAL_CRAFTER.defaultBlockState();
        world.blockState(blockState);
        matrices.pushPose();
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    protected String getTextureLabel() {
        return "Crafter";
    }

    public Class<CrafterRenderState> getRenderStateClass() {
        return CrafterRenderState.class;
    }
}

