/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.CrushWheelRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class CrushWheelRenderer
extends PictureInPictureRenderer<CrushWheelRenderState> {
    private final BlockState blockState = (BlockState)AllBlocks.CRUSHING_WHEEL.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);

    public CrushWheelRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(CrushWheelRenderState state, PoseStack matrices) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-22.5f));
        matrices.translate(-1.5f, -0.6f, -0.5f);
        matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        List parts = blockRenderManager.getBlockModel(this.blockState).collectParts(mc.level.random);
        world.blockState(this.blockState);
        float angle = CrushWheelRenderer.getCurrentAngle();
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-angle));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(this.blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.translate(2.0f, 0.0f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(angle));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(this.blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    public Class<CrushWheelRenderState> getRenderStateClass() {
        return CrushWheelRenderState.class;
    }

    protected String getTextureLabel() {
        return "Crush Wheel";
    }
}

